package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云出库单信息
 */
@Component
public class WmsMnKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "STK_OutStockApply";//出库申请单信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public WmsMnKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FBillNo","FBillNo");//编码
        key.put("FStockOrgId.Fnumber","FStockOrgId.Fnumber");//申请组织
        key.put("FBillTypeID.Fnumber","FBillTypeID.Fnumber");//单据类型
        key.put("FMaterialId.Fnumber","FMaterialId.Fnumber");//物料编码
        key.put("FQty","FQty");//数量
        key.put("FStockId.Fnumber","FStockId.Fnumber");//仓库编码
        key.put("FEntity_FSeq","FEntity_FSeq");//行号
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key,map,"出库申请单信息");
        return PojoToIMS(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> PojoToIMS(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(2).toString());
                    salesordermap.put("pmnCode", list1.get(1).toString());
                    salesordermap.put("pmnType", list1.get(3).toString());
                    salesordermap.put("proidCode", list1.get(4).toString());
                    salesordermap.put("mnTbQty", list1.get(5).toString());
                    salesordermap.put("mnPlanQty", list1.get(5).toString());
                    salesordermap.put("mtrlCode", list1.get(4).toString());
                    salesordermap.put("dosage", list1.get(5).toString());
                    salesordermap.put("nnQty", list1.get(5).toString());
                    salesordermap.put("tnQty", list1.get(5).toString());
                    salesordermap.put("storeCode", list1.get(6).toString());
                    salesordermap.put("thirdRwn", list1.get(7).toString());
                    salesorderlist.add(salesordermap);
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }
}
