package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.*;

@Component
@Data
public class WmsRoKingdeeApi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "SAL_RETURNNOTICE";//退货通知单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public WmsRoKingdeeApi() {
        /*查询字段*/
        key.put("FID", "FID");//单据头实体主键
        key.put("FSaleOrgId.Fnumber", "FSaleOrgId.Fnumber");//销售组织
        key.put("FBillNo", "FBillNo");//编码
        key.put("FBillTypeID.Fnumber", "FBillTypeID.Fnumber");//单据类型
        key.put("FQty", "FQty");//销售数量
        key.put("FMaterialId.Fnumber", "FMaterialId.Fnumber");//物料编码
        key.put("FStockId.Fnumber", "FStockId.Fnumber");//仓库编码
        key.put("FEntity_FENTRYID", "FEntity_FENTRYID");//行内码
        key.put("FRetcustId.Fnumber", "FRetcustId.Fnumber");//供应商编码
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    /**
     * 查询物料行号
     *
     * @param id
     * @return
     */
    public List<List<Object>> getFseq(String id) {
        List<List<Object>> lists = categoryDao.select("BD_MATERIAL", new HashMap<String, String>() {{
            //根据单据编码查询客户ID
            put("FMATERIALID", "FMATERIALID");
            put("FNumber", "FNumber");
        }}, new HashMap<String, String>() {{
            put("FNumber", id);
        }});
        if (CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if (null == lists.get(0).get(0) || "".equals(lists.get(0).get(0))) {
            return null;
        } else if (lists.get(0).get(0).toString().contains("Errors")) {
            return null;
        }
        return lists;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key, map, "退货通知单");
        return PojoToIMS(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> FseqList = new HashMap<>();
                String Fseq = "";

                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    salesordermap.put("roCode", list1.get(2).toString());
                    salesordermap.put("roType", list1.get(3).toString());
                    salesordermap.put("mtrlCode", list1.get(5).toString());
                    salesordermap.put("storeCode", list1.get(6).toString());
                    salesordermap.put("mqty", list1.get(4).toString());
                    if (null == list1.get(5).toString() || " ".equals(list1.get(5).toString())) {
                        salesordermap.put("roMtrlSeq", "");
                    } else {
                        salesordermap.put("roMtrlSeq", getFseq(list1.get(5).toString()).get(0).get(0).toString());
                    }
                    salesordermap.put("FEntity_FENTRYID", list1.get(7).toString());
                    salesordermap.put("supCode", list1.get(8).toString());
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
