package org.jeecg.modules.iost.ims.service.impl;

import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsMtrl;
import org.jeecg.modules.iost.ims.kingdeeapi.BsMtrlKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBsMtrlMapper;
import org.jeecg.modules.iost.ims.service.IImsBsMtrlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 物料基础信息
 * @Author: jeecg-boot
 * @Date:   2021-12-13
 * @Version: V1.0
 */
@Service
public class ImsBsMtrlServiceImpl extends ServiceImpl<ImsBsMtrlMapper, ImsBsMtrl> implements IImsBsMtrlService {
    @Autowired
    IMSApi imsApi;
    @Autowired
    BsMtrlKingdeeApi kingdeeApi;
    @Override
    public Boolean synchronization(Object object,LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "物料基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBsMtrl> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> bs_cust_mtrltf=new HashMap<>();
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FMATERIALID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsBsMtrl pojo = new ImsBsMtrl();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setMtrlName(data.get("mtrlName"));
            pojo.setMtrlDesc(data.get("mtrlDesc"));
            pojo.setMtrlSpcl(data.get("mtrlSpcl"));
            pojo.setMtrlPtype(data.get("mtrlPtype"));
            pojo.setMunit(data.get("munit"));
            pojo.setPackQty(data.get("packQty"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String,Object> datalist=new HashMap<>();
            datalist.put("org_id",data.get("orgId"));
            datalist.put("mtrl_code",data.get("mtrlCode"));
            datalist.put("mtrl_name",data.get("mtrlName"));
            datalist.put("mtrl_desc",data.get("mtrlDesc"));
            int mtrl_spcl = 1;
            if (StringUtils.isNotBlank(data.get("mtrlSpcl"))){
                mtrl_spcl = Integer.parseInt(data.get("mtrlSpcl"));
            }
            datalist.put("mtrl_spcl",mtrl_spcl);
            int mtrl_ptype = 0;
            if ("CHLB01_SYS".equals(data.get("mtrlPtype")) || "CHLB02_SYS".equals(data.get("mtrlPtype"))){
                mtrl_ptype = 1;
            }else if ("CHLB03_SYS".equals(data.get("mtrlPtype")) || "CHLB04_SYS".equals(data.get("mtrlPtype"))) {
                mtrl_ptype = 2;
            }else if ("CHLB05_SYS".equals(data.get("mtrlPtype"))) {
                mtrl_ptype = 3;
            }
            datalist.put("mtrl_ptype", mtrl_ptype);
            if (mtrl_ptype == 2 || mtrl_ptype == 3) {
                datalist.put("phase_code", "0" + data.get("phaseCode"));
            }
            datalist.put("munit",data.get("munit"));
            datalist.put("pack_qty",data.get("packQty"));
            datalist.put("store_code",data.get("storeCode"));
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_MTRL");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "物料信息","BS_MTRL");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "物料信息","BS_MTRL",null);
        //设置同步成功状态
        success=flag;
        return success;
    }

}
