package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsStore;
import org.jeecg.modules.iost.ims.kingdeeapi.BsStoreKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBsStoreMapper;
import org.jeecg.modules.iost.ims.service.IImsBsStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 仓库基础信息
 * @Author: jeecg-boot
 * @Date:   2021-12-07
 * @Version: V1.0
 */
@Service
public class ImsBsStoreServiceImpl extends ServiceImpl<ImsBsStoreMapper, ImsBsStore> implements IImsBsStoreService {
    @Autowired
    BsStoreKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object object,LoginUser sysUser) throws ParseException {

        //追加参数(上下文对象)
        String kingdeeLogOZTName = "仓库基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBsStore> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FStockId",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsBsStore pojo = new ImsBsStore();
            pojo.setFid(data.get("fid"));
            pojo.setStoreCode(data.get("storeCode"));
            pojo.setStoreName(data.get("storeName"));
            pojo.setStoreType(data.get("storeType"));
            pojo.setPptType(Integer.parseInt(data.get("pptType")));
            pojo.setOrgId(data.get("orgId"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String,Object> datalist=new HashMap<>();
            datalist.put("org_id",data.get("orgId"));
            datalist.put("store_code",data.get("storeCode"));
            datalist.put("store_name",data.get("storeName"));
            /*datalist.put("store_type",Integer.valueOf(data.get("storeType")));
            datalist.put("ppt_type",Integer.valueOf(data.get("pptType")));*/
            datalist.put("remark","");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_STORE");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "仓库信息","BS_STORE");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "仓库信息","BS_STORE",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
