package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeLogUtil;
import org.jeecg.modules.iost.ims.entity.ImsCommonSyn;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsCommonKingdeeApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsConstants;
import org.jeecg.modules.iost.ims.mapper.ImsCommonSynMapper;
import org.jeecg.modules.iost.ims.service.IImsCommonSynService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class ImsCommonSynServiceImpl extends ServiceImpl<ImsCommonSynMapper, ImsCommonSyn> implements IImsCommonSynService {

    @Autowired
    private ImsCommonKingdeeApi imsCommonKingdeeApi;

    @Autowired
    private ImsConstants imsConstants;

    @Autowired
    private IMSApi imsApi;


    @Override
    public Boolean synchronization(Object fid, Object formId) {
        //查询表单
        Map<String, String> temp = imsConstants.get(formId.toString());
        if (CollectionUtils.isEmpty(temp)) {
            new KingdeeLogUtil().synLog("通用同步失败", "formId为: " + formId + "的表单不存在");

            return false;
        }

        //追加参数(上下文对象)
        /*String kingDeeLogOZTName = temp.get("name");
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOZTName);*/

        List<Object> objectList = JsonUtil.toList(temp.get("detail"), Object.class);
        List<Map<String, String>> fieldList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, String.class)).collect(Collectors.toList());

        //设置需要同步的主键
        Map<String, String> where = new HashMap<>(1);
        where.put("FID", fid.toString());
        List<Map<String, Object>> list = imsCommonKingdeeApi.selectAndLog(temp.get("formId"), fieldList, where, temp.get("name"));

        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>(3);
        map.put("docType", temp.get("docType"));
        map.put("updateType", "UPDATE");
        map.put("data", list);
        String json = JsonUtil.toString(map);
        String result = imsApi.add(json, temp.get("name"), temp.get("docType"));
        //记录IMS日志
        return new ImsLogUtil().ImsLog(json, result, temp.get("name"), temp.get("docType"), null);
    }


}
