package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsBsSup;
import org.jeecg.modules.iost.ims.service.IImsBsSupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: 供应商基础信息
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Api(tags = "供应商基础信息")
@RestController
@RequestMapping("/imsBsSup")
@Slf4j
public class ImsBsSupController extends JeecgController<ImsBsSup, IImsBsSupService> {
    @Autowired
    private IImsBsSupService imsBsSupService;

    /**
     * 分页列表查询
     *
     * @param imsBsSup
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "供应商基础信息-分页列表查询")
    @ApiOperation(value = "供应商基础信息-分页列表查询", notes = "供应商基础信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsBsSup imsBsSup,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req, String date) {
        QueryWrapper<ImsBsSup> queryWrapper = QueryGenerator.initQueryWrapper(imsBsSup, req.getParameterMap());
        Page<ImsBsSup> page = new Page<ImsBsSup>(pageNo, pageSize);
        if (!"null".equals(date)) {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE, 1);
            String parse1 = sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time", parse);
            queryWrapper.lt("create_time", parse1);
        }
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("create_time", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("sup_code", codeString);
        }
        queryWrapper.orderByDesc("create_time");
        IPage<ImsBsSup> pageList = imsBsSupService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsBsSup
     * @return
     */
    @AutoLog(value = "供应商基础信息-添加")
    @ApiOperation(value = "供应商基础信息-添加", notes = "供应商基础信息-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsBsSup imsBsSup) {
        imsBsSupService.save(imsBsSup);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsBsSup
     * @return
     */
    @AutoLog(value = "供应商基础信息-编辑")
    @ApiOperation(value = "供应商基础信息-编辑", notes = "供应商基础信息-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsBsSup imsBsSup) {
        imsBsSupService.updateById(imsBsSup);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "供应商基础信息-通过id删除")
    @ApiOperation(value = "供应商基础信息-通过id删除", notes = "供应商基础信息-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsBsSupService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "供应商基础信息-批量删除")
    @ApiOperation(value = "供应商基础信息-批量删除", notes = "供应商基础信息-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsBsSupService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "供应商基础信息-通过id查询")
    @ApiOperation(value = "供应商基础信息-通过id查询", notes = "供应商基础信息-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsBsSup imsBsSup = imsBsSupService.getById(id);
        if (imsBsSup == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsBsSup);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsBsSup
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsBsSup imsBsSup) {
        return super.exportXls(request, imsBsSup, ImsBsSup.class, "供应商基础信息");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsBsSup.class);
    }

    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "供应商基础信息-同步")
    @ApiOperation(value = "供应商基础信息-同步", notes = "供应商基础信息-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag = imsBsSupService.synchronization(id, sysUser);
        if (flag) {
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
