package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 收料单信息
 * @Author: jeecg-boot
 * @Date:   2021-12-21
 * @Version: V1.0
 */
@Data
@TableName("ims_wms_ro")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_wms_ro对象", description="收料单信息")
public class ImsWmsRo implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**组织代码*/
	@Excel(name = "组织代码", width = 15)
    @ApiModelProperty(value = "组织代码")
    private java.lang.String orgId;
	/**收料单编码*/
	@Excel(name = "收料单编码", width = 15)
    @ApiModelProperty(value = "收料单编码")
    private java.lang.String roCode;
	/**收料类型*/
	@Excel(name = "收料类型", width = 15)
    @ApiModelProperty(value = "收料类型")
    private java.lang.String roType;
	/**asn订单编码*/
	@Excel(name = "asn订单编码", width = 15)
    @ApiModelProperty(value = "asn订单编码")
    private java.lang.String asn;
	/**工单类型*/
	@Excel(name = "工单类型", width = 15)
    @ApiModelProperty(value = "工单类型")
    private java.lang.String supCode;
	/**计划数量*/
	@Excel(name = "计划数量", width = 15)
    @ApiModelProperty(value = "计划数量")
    private java.lang.String custCode;
	/**加急*/
	@Excel(name = "加急", width = 15)
    @ApiModelProperty(value = "加急")
    private java.lang.String isUrgent;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlCode;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeCode;
	/**物品数量*/
	@Excel(name = "物品数量", width = 15)
    @ApiModelProperty(value = "物品数量")
    private java.lang.String mqty;
	/**物料行号*/
	@Excel(name = "物料行号", width = 15)
    @ApiModelProperty(value = "物料行号")
    private java.lang.String roMtrlSeq;
	/**采购单编码*/
	@Excel(name = "采购单编码", width = 15)
    @ApiModelProperty(value = "采购单编码")
    private java.lang.String poCode;
	/**采购单行号*/
	@Excel(name = "采购单行号", width = 15)
    @ApiModelProperty(value = "采购单行号")
    private java.lang.String poSeq;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
    /**主键ID*/
    @Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
}
