package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云部门基础信息
 */
@Component
public class CompanyKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "BD_Department";//部门基础信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public CompanyKingdeeApi(){
        /*查询字段*/
        key.put("FDEPTID","FDEPTID");//单据头实体主键
        key.put("FNumber","FNumber");//编码
        key.put("FName","FName");//名称
        key.put("FParentID.Fnumber","FParentID.Fnumber");//上级部门
        key.put("FUseOrgId.Fnumber","FUseOrgId.Fnumber");//组织编码
    }
    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key,map,"部门基础信息");
        return PojoToIMS(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> PojoToIMS(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("companyCode", list1.get(1).toString());
                    salesordermap.put("companyCname", list1.get(2).toString());
                    if(null==list1.get(3)||"".equals(list1.get(3).toString())){
                        salesordermap.put("parentCompanyCode", list1.get(4).toString());
                    }else {
                        salesordermap.put("parentCompanyCode", list1.get(3).toString());
                    }
                    salesorderlist.add(salesordermap);
                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }
    @Override
    public String update(Object object) {
        return null;
    }

}
