package org.jeecg.modules.iost.ims.kingdeeapi;

import lombok.Data;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeResultParseUtil;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: ImsInventoryLoss  盘亏
 * @Author: ly
 * @Date: 2021-12-03
 * @Version: V1.0
 */
@Component
@Data
public class ImsInventoryLossApi implements web_api {
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    private String KingdeeLogOZTName;

    public ImsInventoryLossApi() {
        sFormId = "STK_StockCountLoss";  //子单据Formid
        KingdeeLogName = "盘盈单";    //金蝶云修改操作日志-nam
        KingdeeLogOZTName = "盘盈";    //金蝶云修改操作日志对应欧智通-name
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
    public Result addReturnResult(List<Map<String, Object>> lists) {
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        String result = categoryDao.addReturnResult(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap));
        Result result1 = KingdeeResultParseUtil.parseAddResult(result);
        return result1;
    }

    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String, Object>> lists) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Map<String, Object> FEntityMap = new HashMap<>();
            //字段转化
            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间
            ModelMap.put("FStockerId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("USER_CODE"));
            }}); //操作人编码
            ModelMap.put("FStockOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }}); //组织代码
            FEntityMap.put("Fnote", maps.get("REMARK")); //备注
            FEntityMap.put("FStockId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_CODE"));
            }}); //仓库编码
            FEntityMap.put("FMaterialId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("MTRL_CODE"));
            }}); //物料编码
            FEntityMap.put("FCountQty", maps.get("QUANTITY")); //数量
            list.add(FEntityMap);
        }
        ModelMap.put("FBillEntry", list);
        return ModelMap;
    }
}
