package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import lombok.Data;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.Util.KingdeeResultParseUtil;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.entity.ImsReturnMaterialDefectiveProducts;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: ImsReturnMaterialDefectiveProducts  不良品退料
 * @Author: ly
 * @Date:   2021-12-07
 * @Version: V1.0
 */
@Component
@Data
public class ImsReturnMaterialDefectiveProductsApi implements web_api {
    @Autowired
    private CategoryDao categoryDao;

    private String sFormId;
    private String Father_FEnrtyID;
    private String KingdeeLogPushName;
    private String KingdeeLogName;
    private String KingdeeLogOZTName;
    private String Father_sFormId;
    private String push_Rule;
    private String Son_FEnrtyID;
    private String SeqName;
    private String wipOrdeName;
    public ImsReturnMaterialDefectiveProductsApi() {
        sFormId = "PRD_ReturnMtrl";  //子单据Formid
        Father_sFormId = "PRD_PPBOM";  //父单据Formid
        Son_FEnrtyID = "FEntity_FEntryID";  //子单据要查询的FEntryId
        Father_FEnrtyID = "FEntity_FEntryID";  //父单据要查询的FEntryId
        KingdeeLogPushName = "生产退料单(生产用料清单-生产退料单)";  //金蝶云下推操作日志名称
        KingdeeLogName = "生产退料单";    //金蝶云修改操作日志-name
        KingdeeLogOZTName = "不良品退料";    //金蝶云修改操作日志对应欧智通-name
        push_Rule = "PRD_PPBOM2RETURNMTRL";   //父单据下推子单据的规则
        SeqName="FEntrySrcEnteryId";  //子单据里面的源单行号(父单据行号); ps:如果子单据不存在源单行号则换成源单分录内码
        wipOrdeName="FSrcBizBillNo";   //子单据里面的源单编号(父单据工单编号) 或者如果父单据没有工单编号条件改为源单行内码(源单分录内码)
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    public Result addTwo(List<Map<String,Object>> lists) {
        Map<String, Object> stringStringMap = ImsToKingdee(lists);
        Result result = categoryDao.addAndWithFid(KingdeeLogName, sFormId, JsonUtil.Mapjson(stringStringMap),String.valueOf(lists.get(0).get("FID")));
        return result;
    }
    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        return null;
    }

    @Override
    public String update(Object object) {
        return null;
    }
    /*ims字段转换成金蝶云待添加(其实都是下推后修改)字段*/
    public Map<String, Object> ImsToKingdee(List<Map<String,Object>> lists) {
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> ModelMap = new HashMap<>();
        for (Map<String, Object> maps : lists) {
            Map<String, Object> FEntityMap = new HashMap<>();
            FEntityMap.put("FStockId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("STORE_CODE"));
            }}); //仓库编码!
//            FEntityMap.put("FMaterialId", new HashMap<String, Object>() {{
//                put("FNumber", maps.get("MTRL_CODE"));
//            }}); //物料编码!
            FEntityMap.put("FQty", maps.get("QUANTITY")); //数量-实退数量!
            FEntityMap.put("FEntrtyMemo", maps.get("REMARK"));//备注!
            //修改条件FEntryID
            FEntityMap.put("FEntryID", maps.get("FEntry_ID"));//本单据的FEntryID
            FEntityMap.put("FMoBillNo",maps.get(ThreadLocalConfig.get().get("wipOrde").toString()).toString());//生产订单编号
            list.add(FEntityMap);
            //修改条件FID
            ModelMap.put("FID", maps.get("FID"));
            ModelMap.put("FReturnerId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("USER_CODE"));
            }});  //退料人!
            ModelMap.put("FDate", maps.get("TRX_DATE"));  //交易时间!
            //下面两个有些字段单据修改传入会报错
            ModelMap.put("FStockOrgId", new HashMap<String, Object>() {{
                put("FNumber", maps.get("ORG_ID"));
            }});  //组织代码!
        }
        ModelMap.put("FEntity", list);

        return ModelMap;
    }

    /*查询needLists所有数据的父单据的FEntryID*/
    public List<String> queryFatherFEntryIDs(List<Map<String, Object>> needLists,List<Map<String, Object>> SelectFatherFentryIdFailLists)
    {
        List<String> Father_FEntryIDs = new ArrayList<>(); //父单据FEntryID
        for (Map<String, Object> maps : needLists) {
            ImsReturnMaterialDefectiveProducts imsReturnMaterialDefectiveProducts = JSON.parseObject(JSON.toJSONString(maps), ImsReturnMaterialDefectiveProducts.class);//map转为实体类对象
            //查询是否有FEntryID传入，没有就其他方法查询出
            if (ObjectUtils.isEmpty(maps.get("SEQ_ENTRY_CODE"))) {
                //根据父单据编码和行号(ERP工单行号)在数据库同步表查出父单据的FEntryID
                List<List<Object>> FEntryIDlist = categoryDao.check_Father_FentryId(Father_FEnrtyID,maps, Father_sFormId,KingdeeLogName+"父单据行内码查询");
                String FEntryID="0";
                //过滤掉查询不到FEntryID的数据返回"0"
                if(!ObjectUtils.isEmpty(FEntryIDlist)) {
                    if (FEntryIDlist.size()>=1||FEntryIDlist.size()>=Integer.valueOf(imsReturnMaterialDefectiveProducts.getErpSeq())) {
//                        FEntryID = FEntryIDlist.get(Integer.valueOf(imsReturnMaterialDefectiveProducts.getErpSeq()) - 1).get(0).toString();
                        FEntryID = FEntryIDlist.get(0).get(0).toString();
                    }
                }
                else
                {
                    FEntryID="1";
//                    maps.put("notExitFbillNo",true);
                    maps.put("notExitFEntryID",true);//FEntryID使用这个
                    SelectFatherFentryIdFailLists.add(maps);
                }
                //返回FEntryID默认值0说明查不到FEntryID
                if(FEntryID.equals("0"))
                {
                    //查询FEntryID失败后要返结果的lists
                    SelectFatherFentryIdFailLists.add(maps);
                }
                else
                {
                    Father_FEntryIDs.add(FEntryID);
                    maps.put(maps.get(ThreadLocalConfig.get().get("wipOrde")).toString()+maps.get(ThreadLocalConfig.get().get("SEQ")).toString(),FEntryID);
                }

            } else {
                String FEntryID = maps.get("SEQ_ENTRY_CODE").toString();
                Father_FEntryIDs.add(FEntryID);
                maps.put(maps.get(ThreadLocalConfig.get().get("wipOrde")).toString()+maps.get(ThreadLocalConfig.get().get("SEQ")).toString(),FEntryID);
            }
        }
        return Father_FEntryIDs;
    }
    /*父单据下推到子单据*/
    public Result push(List<Map<String, Object>> needPushLists, List<String> Father_FEntryIDs) {
        //目标单据为子单据Formid
        String TargetFormId = sFormId;
        //下推父单据的Fromid-EntryID-单据转换规则(写死，客户端查询)-目标单据FormId-
        String result = categoryDao.pushMore(KingdeeLogPushName, Father_sFormId, Father_FEntryIDs, push_Rule, TargetFormId);
        Result pushResult = KingdeeResultParseUtil.parseAddResult(result);
        System.out.println("fsfadsfd                           "+pushResult+true);
        return pushResult;
    }
    /*查询数据的子单据的FEntryID*/
    public String querySonFEntryID(String F,String seq, String FID) {
        if (ObjectUtils.isEmpty(FID)) {
            FID = new String();
        }
        String FEntity_FEntryId = categoryDao.select_Son_FentryIdSpecial(F,SeqName,Son_FEnrtyID, Integer.valueOf(seq),FID,sFormId,KingdeeLogName+"子单据行内码查询");
        return FEntity_FEntryId;
    }
}
