package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsCust;
import org.jeecg.modules.iost.ims.kingdeeapi.BsCustKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBsCustMapper;
import org.jeecg.modules.iost.ims.service.IImsBsCustService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 客户基础信息
 * @Author: jeecg-boot
 * @Date:   2021-12-02
 * @Version: V1.0
 */
@Service
public class ImsBsCustServiceImpl extends ServiceImpl<ImsBsCustMapper, ImsBsCust> implements IImsBsCustService {
    @Autowired
    BsCustKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object object,LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "客户基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);
        ThreadLocalConfig.set(map2);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBsCust> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = true;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FCUSTID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsBsCust pojo = new ImsBsCust();
            pojo.setFid(data.get("fid"));
            pojo.setCustCode(data.get("custCode"));
            pojo.setCustName(data.get("custName"));
            pojo.setErpCustCode(data.get("erpCustCode"));
            pojo.setCustMtrlCode(data.get("cust_mtrl_code"));
            pojo.setMtrlCode(data.get("mtrl_code"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String,Object> datalist=new HashMap<>();
            if (StringUtils.isNotBlank(data.get("mtrl_code")) && StringUtils.isNotBlank(data.get("cust_mtrl_code"))) {
                List<Map<String,String>> bsList = new ArrayList<>();
                Map<String,String> bs_cust_mtrltf=new HashMap<>();
                bs_cust_mtrltf.put("cust_mtrl_code",data.get("cust_mtrl_code"));
                bs_cust_mtrltf.put("mtrl_code",data.get("mtrl_code"));
                bsList.add(bs_cust_mtrltf);
                datalist.put("bs_cust_mtrltf",bsList);
            }
            datalist.put("cust_code",data.get("custCode"));
            datalist.put("cust_name",data.get("custName"));
            datalist.put("erp_cust_code",data.get("erpCustCode"));
            datalist.put("remark","");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_CUST");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "客户信息","BS_CUST");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "客户信息","BS_CUST",null);
        //设置同步成功状态
        success=flag;
        return success;
    }

}
