package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsPickingList;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsPickingListKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsPickingListMapper;
import org.jeecg.modules.iost.ims.service.IImsPickingListService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * @author Inori
 */
@Service
public class ImsPickingListServiceImpl extends ServiceImpl<ImsPickingListMapper, ImsPickingList> implements IImsPickingListService {

    private static final Logger log = LoggerFactory.getLogger(ImsPickingListServiceImpl.class);

    @Autowired
    private IMSApi imsApi;

    @Autowired
    private ImsPickingListKingdeeApi imsPickingListKingdeeApi;


    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) {
        //追加参数(上下文对象)
        String kingDeeLogOZTName = "提料分析";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOZTName);

        //设置需要同步的主键
        Map<String, String> whereMap = new HashMap<>();
        whereMap.put("FID", object.toString());
        List<Map<String, String>> list = imsPickingListKingdeeApi.select(whereMap);

        Boolean flag;
        List<ImsPickingList> pojoList = new ArrayList<>();
        List<Map<String, Object>> imsList = new ArrayList<>();
        for (Map<String, String> map : list) {
            if (map.containsKey("false")) {
                return false;
            }

            ImsPickingList imsPickingList = new ImsPickingList();
            imsPickingList.setFid(map.get("fid"));
            imsPickingList.setSupMtrlDtAnalNo(map.get("supMtrlDtAnalNo"));
            imsPickingList.setPushCount(Integer.parseInt(map.get("pushCount")));
            imsPickingList.setCreateTime(new Date());
            pojoList.add(imsPickingList);

            Map<String, Object> imsMap = new HashMap<>(11);
            imsMap.put("po_code", map.get("poCode"));
            imsMap.put("mtrl_code", map.get("mtrlCode"));
            imsMap.put("deliverable_qty", new BigDecimal(map.get("deliverableQty")));
            imsMap.put("sup_code", map.get("supCde"));
            imsMap.put("sup_mtrl_dt_anal_no", map.get("supMtrlDtAnalNo"));
            imsMap.put("m_unit", map.get("mUnit"));
            int poSeq = 0;
            if (StringUtils.isNotBlank(map.get("poSeq"))) {
                poSeq = Integer.parseInt(map.get("poSeq"));
            }
            imsMap.put("po_seq", poSeq);
            imsMap.put("demand_date", map.get("demandDate"));
            imsMap.put("sdl_no", map.get("sdlNo"));
            imsMap.put("sdl_mtrl", map.get("sdlMtrl"));
            imsList.add(imsMap);
        }
        this.saveBatch(pojoList);

        //将数据包装成IMS格式
        Map<String, Object> map = new HashMap<>(3);
        map.put("docType", "SUP_MTRL_DT_DATA");
        map.put("updateType", "UPDATE");
        map.put("data", imsList);
        String json = JsonUtil.toString(map);
        String result = imsApi.add(json, "提料分析单", "SUP_MTRL_DT_DATA");
        //记录IMS日志
        flag = new ImsLogUtil().ImsLog(json, result, "提料分析单", "SUP_MTRL_DT_DATA", null);

        if (!CollectionUtils.isEmpty(imsList) && anAl(imsList.get(0).get("sup_mtrl_dt_anal_no").toString())) {
            Map<String, Object> noMap = new HashMap<>(3);
            noMap.put("docType", "SUP_MTRL_DT_DATA_ANAL");
            noMap.put("updateType", "UPDATE");
            noMap.put("data", new ArrayList<Map<String, Object>>().add(new HashMap<String, Object>(1) {{
                put("sup_mtrl_dt_anal_no", imsList.get(0).get("sup_mtrl_dt_anal_no"));
            }}));
            String noJson = JsonUtil.toString(noMap);
            String noResult = imsApi.add(noJson, "提料单计算", "SUP_MTRL_DT_DATA_ANAL");
            //记录IMS日志
            new ImsLogUtil().ImsLog(noJson, noResult, "提料单计算", "SUP_MTRL_DT_DATA_ANAL", null);
        }
        return flag;
    }

    public boolean anAl(String supMtrlDtAnalNo) {
        Integer count = this.getBaseMapper().selectCount(new QueryWrapper<ImsPickingList>().eq("sup_mtrl_dt_anal_no", supMtrlDtAnalNo));

        ImsPickingList imsPickingList = this.getBaseMapper().selectOne(new QueryWrapper<ImsPickingList>().eq("sup_mtrl_dt_anal_no", supMtrlDtAnalNo).orderByDesc("create_time").last("limit 1"));
        log.info("分析单号: {}, 以同步数量: {}, 需求同步数量: {}", supMtrlDtAnalNo, count, imsPickingList != null ? imsPickingList.getPushCount() : 0);

        return imsPickingList != null && imsPickingList.getPushCount().equals(count);
    }


}
