package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.PurchaseReturnKingdeeApi;
import org.jeecg.modules.iost.ims.service.IImsPurchaseReturnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class ImsPurchaseReturnServiceImpl implements IImsPurchaseReturnService {

    @Autowired
    private PurchaseReturnKingdeeApi purchaseReturnKingdeeApi;


    @Override
    public Map<String, Object> getData(Map<String, Object> map) {
        String kingDeeLogOZTName = "采购退料查询";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingDeeLogOZTName);

        //记录IMS日志
        new ImsLogUtil().ImsRequestLog(JsonUtil.toString(map), "采购退料", "采购退料查询", "PUR_MRB");

        Map<String, String> whereMap = new HashMap<>(4);
        if (map.containsKey("RETURN_MATERIAL_NO")) {
            whereMap.put("FBillNo", map.get("RETURN_MATERIAL_NO").toString());
        }
        if (map.containsKey("SUPPLIER_CODE")) {
            whereMap.put("FSupplierId.Fnumber", map.get("SUPPLIER_CODE").toString());
        }
        if (map.containsKey("RETURN_MATERIAL_DATE")) {
            whereMap.put("FDate", map.get("RETURN_MATERIAL_DATE").toString());
        }
        if (map.containsKey("MATERIAL_CODE")) {
            whereMap.put("FMaterialId.Fumber", map.get("MATERIAL_CODE").toString());
        }
        List<Map<String, Object>> list = purchaseReturnKingdeeApi.selectAndLog(whereMap, "采购退料查询");

        Map<String, Object> result = new HashMap<>(1);
        if (!CollectionUtils.isEmpty(list)) {
            if (list.get(0).containsKey("false")) {
                result.put("false", list.get(0).get("false"));
            } else {
                result.put("true", list);
            }
        } else {
            result.put("true", list);
        }
        return result;
    }


}
