package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsWmsAudit;
import org.jeecg.modules.iost.ims.kingdeeapi.WmsAuditKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWmsAuditMapper;
import org.jeecg.modules.iost.ims.service.IImsWmsAuditService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * @Description: 发货通知单
 * @Author: jeecg-boot
 * @Date:   2021-12-23
 * @Version: V1.0
 */
@Service
public class ImsWmsAuditServiceImpl extends ServiceImpl<ImsWmsAuditMapper, ImsWmsAudit> implements IImsWmsAuditService {
    @Autowired
    WmsAuditKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object object, LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "发货通知单";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsWmsAudit> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsWmsAudit pojo = new ImsWmsAudit();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setAuditCode(data.get("auditCode"));
            pojo.setAuditSeq(data.get("auditSeq"));
            pojo.setCustCode(data.get("custCode"));
            pojo.setShipDate(data.get("shipDate"));
            pojo.setShipType(data.get("shipType"));
            pojo.setShipCode(data.get("shipCode"));
            pojo.setStoreCode(data.get("storeCode"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setMqty(data.get("mqty"));
            pojo.setSaleCode(data.get("saleCode"));
            pojo.setSaleSeq(data.get("saleSeq"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            List<Map<String,String>> bsList = new ArrayList<>();
            Map<String,String> wms_allot_mtrl=new HashMap<>();
            wms_allot_mtrl.put("store_code",data.get("storeCode"));
            wms_allot_mtrl.put("mtrl_code",data.get("mtrlCode"));
            wms_allot_mtrl.put("m_qty",data.get("mqty"));
            wms_allot_mtrl.put("sale_code",data.get("saleCode"));
            wms_allot_mtrl.put("sale_seq",data.get("saleSeq"));
            bsList.add(wms_allot_mtrl);
            Map<String,Object> datalist=new HashMap<>();
            datalist.put("org_id",data.get("orgId"));
            datalist.put("audit_code",data.get("auditCode"));
            datalist.put("audit_seq",data.get("auditSeq"));
            datalist.put("cust_code",data.get("custCode"));
            datalist.put("ship_date",DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss").format(LocalDateTime.parse(data.get("shipDate"))));
            datalist.put("ship_type",data.get("shipType"));
            datalist.put("ship_code",data.get("shipCode"));
            datalist.put("wms_allot_mtrl",bsList);
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","WMS_AUDIT");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "发货通知单信息","WMS_AUDIT");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "发货通知单信息","WMS_AUDIT",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
