package org.jeecg.modules.iost.ims.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsWmsRo;
import org.jeecg.modules.iost.ims.kingdeeapi.WmsRoKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsWmsRoMapper;
import org.jeecg.modules.iost.ims.service.IImsWmsRoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * @Description: 收料单信息
 * @Author: jeecg-boot
 * @Date:   2021-12-21
 * @Version: V1.0
 */
@Service
public class ImsWmsRoServiceImpl extends ServiceImpl<ImsWmsRoMapper, ImsWmsRo> implements IImsWmsRoService {
    @Autowired
    WmsRoKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;
    @Override
    public Boolean synchronization(Object object,LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "收料单信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsWmsRo> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FID",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsWmsRo pojo = new ImsWmsRo();
            pojo.setFid(data.get("fid"));
            pojo.setOrgId(data.get("orgId"));
            pojo.setRoCode(data.get("roCode"));
            pojo.setRoType(data.get("roType"));
            pojo.setMtrlCode(data.get("mtrlCode"));
            pojo.setStoreCode(data.get("storeCode"));
            pojo.setRoMtrlSeq(data.get("roMtrlSeq"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            List<Map<String,Object>> bsList = new ArrayList<>();
            Map<String,Object> wms_ro_mtrl_dt=new HashMap<>();
            wms_ro_mtrl_dt.put("mtrl_code",data.get("mtrlCode"));
            wms_ro_mtrl_dt.put("store_code",data.get("storeCode"));
            wms_ro_mtrl_dt.put("m_qty", new BigDecimal(data.get("mqty")));
            wms_ro_mtrl_dt.put("ro_mtrl_seq", Integer.parseInt(data.get("roMtrlSeq")));
            bsList.add(wms_ro_mtrl_dt);
            Map<String,Object> datalist=new HashMap<>();
            datalist.put("org_id",data.get("orgId"));
            datalist.put("ro_code",data.get("roCode"));
            /*if (StringUtils.isNotBlank(data.get("supCode"))) {
                datalist.put("sup_code",data.get("supCode"));
            }*/
            datalist.put("ro_type",/*Integer.valueOf(data.get("roType"))*/8);
            datalist.put("wms_ro_mtrl_dt",bsList);
            datalist.put("remark","");
            imsList.add(datalist);
        }
        this.saveBatch(pojolist);
        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","WMS_RO");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "退货通知单","WMS_RO");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "退货通知单","WMS_RO",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
