package org.jeecg.modules.iost.ims.TimeTask;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.common.exception.ConnectConstant.KingDeeConstant;
import org.jeecg.modules.iost.ims.client.KingdeeK3CloudApiClient;
import org.jeecg.modules.iost.ims.service.ISynService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.ParseException;
@Slf4j
@Component
@EnableScheduling
public class SynTimed implements Job {

    @Autowired
    ISynService synService;
    @Autowired
    CategoryDao categoryDao;
    /*金蝶云自动登录定时任务20分钟执行一次*/
    @Scheduled(fixedRate = 1000*60*20)
    public void timed() throws IOException, ParseException {
        KingdeeK3CloudApiClient client2 = categoryDao.getClient();
        KingdeeK3CloudApiClient client3 = categoryDao.getClient();
        Boolean result=categoryDao.getResult();
        Boolean result2=categoryDao.getResult();
        String dbId = categoryDao.getDbId();
        String uid = categoryDao.getUid();
        String pwd = categoryDao.getPwd();
        int lang = categoryDao.getLang();
        String loginResult=new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client2.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            log.error(KingDeeConstant.URL);
            result=false;
            categoryDao.setLoginResult(KingDeeConstant.URL);
        }
        com.alibaba.fastjson.JSONObject jsonObject=new JSONObject();
        try {
             jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e)
        {
            log.error(KingDeeConstant.PORT);
            result=false;
            categoryDao.setLoginResult(KingDeeConstant.PORT);
        }
        if(!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                log.error(KingDeeConstant.LoginValue);
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.LoginValue);
            }
            else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                log.error(KingDeeConstant.DBID);
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.DBID);
            }
            else {
                result = true;
                log.info("金蝶云登录成功");
            }

        }
        try {
            result = client2.login(dbId, uid, pwd, lang);
        } catch (Exception e) {
            e.printStackTrace();
        }
        categoryDao.setClient(client2);
        categoryDao.setResult(result);
        try {
            Thread.sleep(1000*60*15);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object[] loginInfo2 = new Object[]{dbId, uid, pwd, lang};
        String loginResult2=new String();
        try {
            loginResult2 = client3.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo2, String.class);
        } catch (Exception e) {
            log.error(KingDeeConstant.URL);
            result2=false;
            categoryDao.setLoginResult(KingDeeConstant.URL);
        }
        com.alibaba.fastjson.JSONObject jsonObject2=new JSONObject();
        try {
            jsonObject2 = JSON.parseObject(loginResult2);
        } catch (Exception e)
        {
            log.error(KingDeeConstant.PORT);
            result2=false;
            categoryDao.setLoginResult(KingDeeConstant.PORT);
        }
        if(!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject2.get("Message"))) {
                log.error(KingDeeConstant.LoginValue);
                result2 = false;
                categoryDao.setLoginResult(KingDeeConstant.LoginValue);
            }
            else if (KingDeeConstant.DBID.equals(jsonObject2.get("Message"))) {
                log.error(KingDeeConstant.DBID);
                result2 = false;
                categoryDao.setLoginResult(KingDeeConstant.DBID);
            }
            else {
                result2 = true;
                log.info("金蝶云登录成功");
            }
        }

        try {
            result2 = client3.login(dbId, uid, pwd, lang);
        } catch (Exception e) {
            e.printStackTrace();
        }

        categoryDao.setClient(client3);
        categoryDao.setResult(result2);
    }

    //可以使用页面上的任务来控制方法
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
    /*    try {
            synService.synchronization(null);
        } catch (ParseException e) {
            e.printStackTrace();
        }*/
    }
}
