package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsDefectiveFlitting;
import org.jeecg.modules.iost.ims.service.IImsDefectiveFlittingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 良品调拨
 * @Author: jeecg-boot
 * @Date: 2021-12-31
 * @Version: V1.0
 */
@Api(tags = "良品调拨")
@RestController
@RequestMapping("/org.jeecg.modules.iost.ims.entity/imsDefectiveFlitting")
@Slf4j
public class ImsDefectiveFlittingController extends JeecgController<ImsDefectiveFlitting, IImsDefectiveFlittingService> {
    @Autowired
    private IImsDefectiveFlittingService imsDefectiveFlittingService;

    /**
     * 分页列表查询
     *
     * @param imsDefectiveFlitting
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "良品调拨-分页列表查询")
    @ApiOperation(value = "良品调拨-分页列表查询", notes = "良品调拨-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsDefectiveFlitting imsDefectiveFlitting,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsDefectiveFlitting> queryWrapper = QueryGenerator.initQueryWrapper(imsDefectiveFlitting, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0] + " 00:00:00", split[1] + " 00:00:00");
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        Page<ImsDefectiveFlitting> page = new Page<ImsDefectiveFlitting>(pageNo, pageSize);
        IPage<ImsDefectiveFlitting> pageList = imsDefectiveFlittingService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsDefectiveFlitting
     * @return
     */
    @AutoLog(value = "良品调拨-添加")
    @ApiOperation(value = "良品调拨-添加", notes = "良品调拨-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsDefectiveFlitting imsDefectiveFlitting) {
        imsDefectiveFlittingService.save(imsDefectiveFlitting);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsDefectiveFlitting
     * @return
     */
    @AutoLog(value = "良品调拨-编辑")
    @ApiOperation(value = "良品调拨-编辑", notes = "良品调拨-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsDefectiveFlitting imsDefectiveFlitting) {
        imsDefectiveFlittingService.updateById(imsDefectiveFlitting);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "良品调拨-通过id删除")
    @ApiOperation(value = "良品调拨-通过id删除", notes = "良品调拨-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsDefectiveFlittingService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "良品调拨-批量删除")
    @ApiOperation(value = "良品调拨-批量删除", notes = "良品调拨-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsDefectiveFlittingService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "良品调拨-通过id查询")
    @ApiOperation(value = "良品调拨-通过id查询", notes = "良品调拨-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsDefectiveFlitting imsDefectiveFlitting = imsDefectiveFlittingService.getById(id);
        if (imsDefectiveFlitting == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsDefectiveFlitting);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsDefectiveFlitting
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsDefectiveFlitting imsDefectiveFlitting) {
        return super.exportXls(request, imsDefectiveFlitting, ImsDefectiveFlitting.class, "良品调拨");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsDefectiveFlitting.class);
    }

}
