package org.jeecg.modules.iost.ims.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: 产品出货
 * @Author: jeecg-boot
 * @Date:   2021-12-30
 * @Version: V1.0
 */
@Data
@TableName("ims_product_out")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_product_out对象", description="产品出货")
public class ImsProductOut implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private java.lang.String sysOrgCode;
	/**唯一序号*/
	@Excel(name = "唯一序号", width = 15)
    @ApiModelProperty(value = "唯一序号")
    private java.lang.String queueId;
	/**交易时间*/
	@Excel(name = "交易时间", width = 15)
    @ApiModelProperty(value = "交易时间")
    private java.lang.String trxDate;
	/**操作人编码*/
	@Excel(name = "操作人编码", width = 15)
    @ApiModelProperty(value = "操作人编码")
    private java.lang.String userCode;
	/**组织代码*/
	@Excel(name = "组织代码", width = 15)
    @ApiModelProperty(value = "组织代码")
    private java.lang.String orgId;
	/**仓库编码*/
	@Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private java.lang.String storeCode;
	/**物料编码*/
	@Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private java.lang.String mtrlCode;
	/**数量*/
	@Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private java.lang.String quantity;
	/**通知单编码*/
	@Excel(name = "通知单编码", width = 15)
    @ApiModelProperty(value = "通知单编码")
    private java.lang.String auditCode;
	/**通知单行号*/
	@Excel(name = "通知单行号", width = 15)
    @ApiModelProperty(value = "通知单行号")
    private java.lang.String auditSeq;
	/**备注*/
	@Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private java.lang.String remark;
	/**主键ID*/
	@Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private java.lang.String fid;
	/**编码*/
	@Excel(name = "编码", width = 15)
    @ApiModelProperty(value = "编码")
    private java.lang.String fbillno;
	/**实体主键*/
	@Excel(name = "实体主键", width = 15)
    @ApiModelProperty(value = "实体主键")
    private java.lang.String fentryId;
	/**行号*/
	@Excel(name = "行号", width = 15)
    @ApiModelProperty(value = "行号")
    private java.lang.String fseq;
}
