package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.TimeUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
/**
 * 查询委外订单信息
 */
@Component
public class BsWplanOutsKingdeeApi implements web_api {
    /**操作的单据体名称*/
    private String sFormId = "SUB_SUBREQORDER";//委外订单
    @Autowired
    private CategoryDao categoryDao;
    private Map<String,String> key = new LinkedHashMap<>();
    public BsWplanOutsKingdeeApi(){
        /*查询字段*/
        key.put("FID","FID");//单据头实体主键
        key.put("FSubOrgId.Fnumber","FSubOrgId.Fnumber");//生产组织
        key.put("FBillNo","FBillNo");//编码
        key.put("FMaterialId.Fnumber","FMaterialId.Fnumber");//物料编码
        key.put("FQty","FQty");//数量
        key.put("FPlanStartDate","FPlanStartDate");//计划开工时间
        key.put("FPlanFinishDate","FPlanFinishDate");//计划完工时间
        key.put("FSaleOrderId","FSaleOrderId");//销售订单ID
        key.put("FFinishDate","FFinishDate");//完工日期
        key.put("FDescription","FDescription");//备注
        key.put("FParentRowId","FParentRowId");//父级行主键
        key.put("FTreeEntity_Fseq","FTreeEntity_Fseq");//行号
        key.put("FTreeEntity_FEntryId","FTreeEntity_FEntryId");//行内码
    }
    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }
    /**
     * 查询销售订单中的客户编码
     * @param id
     * @return
     */
    public List<List<Object>> getCustid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SAL_SaleOrder", new HashMap<String, String>() {{
            //根据单据编码查询客户ID
            put("FCustId.FNumber", "FCustId.FNumber");
            put("FID","FID");
        }}, new HashMap<String, String>() {{
            put("FID", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if( null==lists.get(0).get(0)||"".equals(lists.get(0).get(0))){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }
    /**
     * 查询父级的子项物料编码
     * @param id
     * @return
     */
    public List<List<Object>> getMaterid(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SUB_SUBREQORDER", new HashMap<String, String>() {{
            //根据单据编码查询子项物料编码
            put("FMaterialId.Fnumber", "FMaterialId.Fnumber");
            put("FROWID","FROWID");
        }}, new HashMap<String, String>() {{
            put("FROWID", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if(lists.isEmpty()||("").equals(lists.get(0).get(0).toString())){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }
    /**
     * 查询委外用料清单
     * @param id
     * @return
     */
    public List<List<Object>> getwplanMn(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SUB_PPBOM", new HashMap<String, String>() {{
            //根据单据编码查询客户ID
            put("FEntity_FEntryID", "FEntity_FEntryID");
            put("FEntity_Fseq", "FEntity_Fseq");
            put("FSubReqBillNO","FSubReqBillNO");
        }}, new HashMap<String, String>() {{
            put("FSubReqBillNO", id);
        }});
        if(CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if( null==lists.get(0).get(0)||"0".equals(lists.get(0).get(1).toString())){
            return null;
        }else if (lists.get(0).get(0).toString().contains("Errors")){
            return null;
        }
        return lists;
    }
    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key,map,"主计划信息");
        return PojoToIMS(list);
    }
    /**
     * 将查询到的数据封装成本地字段
     * @return
     */
    private List<Map<String,String>> PojoToIMS(List<List<Object>> list){
        List<Map<String,String>> salesorderlist = new ArrayList<>();
        if(!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> MaterMap = new HashMap<>();
                String Mater = "";
                Map<String, List<String>> CustMap = new HashMap<>();
                String Cust = "";
                Map<String, List<String>> wplanMnMap = new HashMap<>();
                String wplanMn = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    String fseq="";
                    if(list1.get(11).toString().length()==1){
                        fseq="00"+list1.get(11);
                    }else if(list1.get(11).toString().length()==2){
                        fseq="0"+list1.get(11);
                    }
                    salesordermap.put("wplanCode", list1.get(3)+"_"+fseq);
                    salesordermap.put("erpMo", list1.get(2).toString());
                    salesordermap.put("prodCode", list1.get(3).toString());
                    salesordermap.put("pqty", list1.get(4).toString());
                    Date parse = null;
                    Date parse1 = null;
                    try {
                        parse = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(5).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pbdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("pbDate", pbdate);
                    try {
                        parse1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").parse(TimeUtil.timeSSS(list1.get(6).toString()));
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    String pedate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(parse);
                    salesordermap.put("peDate",pedate);

                    if(null==list1.get(7)){
                        salesordermap.put("custCode","");
                    }else {
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //物料编码
                        idList.add(list1.get(7).toString());
                        //主键ID
                        CustMap.put(list1.get(12).toString(), idList);
                        //拼接id做批量查询
                        Cust = "'"+list1.get(7).toString() + "'," + Cust;
                        salesordermap.put("FSaleOrderId",list1.get(7).toString());
                    }
//                    Object custid = getCustid(list1.get(7).toString());
//                    salesordermap.put("custCode", custid.toString());
                    salesordermap.put("ptCode", "");
                    salesordermap.put("mtrlCode", list1.get(3).toString());
                    if(null==list1.get(8)||" ".equals(list1.get(8).toString())){
                        salesordermap.put("deliveryDate","");
                    }else {
                        salesordermap.put("deliveryDate", list1.get(8).toString());
                    }
                    if(null==list1.get(10)||" ".equals(list1.get(10).toString())){
                        salesordermap.put("isMain","Y");
                        salesordermap.put("mainCode",list1.get(3).toString());
                    }else {
                        salesordermap.put("isMain","N");
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //物料编码
                        idList.add(list1.get(10).toString());
                        //主键ID
                        MaterMap.put(list1.get(12).toString(), idList);
                        //拼接id做批量查询
                        Mater = "'"+list1.get(10).toString() + "'," + Mater;
//                        Object materid = getMaterid(list1.get(10).toString());
//                        salesordermap.put("mainCode",materid.toString());
                    }
                    salesordermap.put("FParentRowId",list1.get(10).toString());
                    salesordermap.put("FTreeEntity_FEntryId",list1.get(12).toString());

                    if(null==list1.get(2)||" ".equals(list1.get(2).toString())){
                        salesordermap.put("bsWplanMnMtrlEx1","");
                        salesordermap.put("bsWplanMnMtrlEx2","");
                    }else {
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //物料编码
                        idList.add(list1.get(2).toString());
                        //主键ID
                        wplanMnMap.put(list1.get(12).toString(), idList);
                        //拼接id做批量查询
                        wplanMn = "'"+list1.get(2).toString() + "'," + wplanMn;

                    }
//                    List list2 = wplanMn(list1.get(2).toString());
//                    salesordermap.put("bsWplanMnMtrlEx1",list2.get(1).toString());
//                    salesordermap.put("bsWplanMnMtrlEx2", list2.get(0).toString());
                    salesorderlist.add(salesordermap);
                }
                if("".equals(Mater)){

                }else {
                    //批量查出所有生产用料清单的数据
                    Mater=Mater.substring(0,Mater.length()-1);
                    List<List<Object>> materid = getMaterid(Mater);
                    if (null == materid || "".equals(materid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("mainCode", "");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : MaterMap.keySet()) {
                            for(List materList: materid){
                                //如果对应的行内码相同
                                if (MaterMap.get(fid).get(0).equals(materList.get(1).toString())) {
                                    //将信息添加到集合
                                    MaterMap.get(fid).add(materList.get(0).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : MaterMap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("FTreeEntity_FEntryId"))&&MaterMap.get(fid).get(0).equals(salesordermap.get("FParentRowId"))) {
                                    //如果对应的编码不为空
                                    if (null != MaterMap.get(fid).get(1)) {
                                        salesordermap.put("mainCode", MaterMap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("mainCode", "");
                                    }
                                }
                            }
                        }
                    }
                }
                if(!"".equals(Cust)){
                    //批量查出所有生产用料清单的数据
                    Cust=Cust.substring(0,Cust.length()-1);
                    List<List<Object>> custid = getCustid(Cust);
                    if (null == custid || "".equals(custid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("custCode","");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : CustMap.keySet()) {
                            for(List custlist: custid){
                                //如果对应的行内码相同
                                if (CustMap.get(fid).get(0).equals(custlist.get(0).toString())) {
                                    //将信息添加到集合
                                    CustMap.get(fid).add(custlist.get(1).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : CustMap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("FTreeEntity_FEntryId"))&&CustMap.get(fid).get(0).equals(salesordermap.get("FSaleOrderId"))) {
                                    //如果对应的编码不为空
                                    if (null != CustMap.get(fid).get(1)) {
                                        salesordermap.put("custCode", CustMap.get(fid).get(1));
                                    } else {
                                        salesordermap.put("custCode","");
                                    }
                                }
                            }
                        }
                    }
                }
                if(!"".equals(wplanMn)){
                    //批量查出所有生产用料清单的数据
                    wplanMn=wplanMn.substring(0,wplanMn.length()-1);
                    List<List<Object>> wplanMnid = getwplanMn(wplanMn);
                    if (null == wplanMnid || "".equals(wplanMnid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("bsWplanMnMtrlEx1","");
                            salesordermap.put("bsWplanMnMtrlEx2","");
                        }
                    }else {
                        //将集合赋值
                        for (String fid : wplanMnMap.keySet()) {
                            for(List wplanList: wplanMnid){
                                //如果对应的编码相同
                                if (wplanMnMap.get(fid).get(0).equals(wplanList.get(2).toString())) {
                                    //将信息添加到集合
                                    wplanMnMap.get(fid).add(wplanList.get(1).toString());
                                    wplanMnMap.get(fid).add(wplanList.get(0).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : wplanMnMap.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("FTreeEntity_FEntryId"))&&wplanMnMap.get(fid).get(0).equals(salesordermap.get("erpMo"))) {
                                    //如果对应的编码不为空
                                    if (null != wplanMnMap.get(fid).get(1)) {
                                        salesordermap.put("bsWplanMnMtrlEx1",wplanMnMap.get(fid).get(1));
                                        salesordermap.put("bsWplanMnMtrlEx2",wplanMnMap.get(fid).get(2));
                                    } else {
                                        salesordermap.put("bsWplanMnMtrlEx1","");
                                        salesordermap.put("bsWplanMnMtrlEx2","");
                                    }
                                }
                            }
                        }
                    }

                }
            }else {
                //如果有错误信息则返回
                Map<String,Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
