package org.jeecg.modules.iost.ims.kingdeeapi;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.kingdeeapi.Interface.web_api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.*;

/**
 * 查询金蝶云发货通知单基础信息
 */
@Component
public class WmsAuditKingdeeApi implements web_api {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "SAL_DELIVERYNOTICE";//发货通知单基础信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public WmsAuditKingdeeApi() {
        /*查询字段*/
        key.put("FID", "FID");//单据头实体主键
        key.put("FBillNo", "FBillNo");//编码
        key.put("FSaleOrgId.Fnumber", "FSaleOrgId.Fnumber");//销售组织编码
        key.put("FEntity_Fseq", "FEntity_Fseq");//行号
        key.put("FCustomerID.Fnumber", "FCustomerID.Fnumber");//客户编码
        key.put("FDeliveryDate", "FDeliveryDate");//要货日期
        key.put("FOwnerTypeIdHead", "FOwnerTypeIdHead");//货主类型
        key.put("FOwnerIdHead.Fnumber", "FOwnerIdHead.Fnumber");//货主编码
        key.put("FStockID.Fnumber", "FStockID.Fnumber");//出货仓库
        key.put("FMaterialID.Fnumber", "FMaterialID.Fnumber");//物料编码
        key.put("FQty", "FQty");//数量
        key.put("FSOEntryId", "FSOEntryId");//销售订单entryID
        key.put("FEntity_FEntryID", "FEntity_FEntryID");//单据行内码
    }

    @Override
    public String add(Map<String, Object> maps) {
        return null;
    }

    /**
     * 查询销售订单编码和行号
     *
     * @param id
     * @return
     */
    public List<List<Object>> getSale(String id) {
        List<List<Object>> lists = categoryDao.selectByIds("SAL_SaleOrder", new HashMap<String, String>() {{
            put("FBillNo", "FBillNo");
            put("FSaleOrderEntry_Fseq", "FSaleOrderEntry_Fseq");
            put("FSaleOrderEntry_FEntryID", "FSaleOrderEntry_FEntryID");
        }}, new HashMap<String, String>() {{
            put("FSaleOrderEntry_FEntryID", id);
        }});
        if (CollectionUtils.isEmpty(lists)) {
            return null;
        }
        return lists;
    }

    @Override
    public List<Map<String, String>> select(Map<String, String> map, String where) throws ParseException {
        List<List<Object>> list = categoryDao.select(sFormId, key, map, "发货通知单基础信息");
        return PojoToIMS(list);
    }

    /**
     * 将查询到的数据封装成本地字段
     *
     * @return
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                Map<String, List<String>> SaleList = new HashMap<>();
                String Sale = "";
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(2).toString());
                    salesordermap.put("auditCode", list1.get(1).toString());
                    salesordermap.put("auditSeq", list1.get(3).toString());
                    salesordermap.put("custCode", list1.get(4).toString());
                    salesordermap.put("shipDate", list1.get(5).toString());
                    salesordermap.put("shipType", list1.get(6).toString());
                    if (null == list1.get(7)) {
                        salesordermap.put("shipCode", "");
                    } else {
                        salesordermap.put("shipCode", list1.get(7).toString());
                    }
                    if (null == list1.get(8)) {
                        salesordermap.put("storeCode", "");
                    } else {
                        salesordermap.put("storeCode", list1.get(8).toString());
                    }
                    salesordermap.put("mtrlCode", list1.get(9).toString());
                    salesordermap.put("mqty", list1.get(10).toString());
                    if (null == list1.get(11) || "0".equals(list1.get(11).toString())) {
                        salesordermap.put("saleCode", "");
                        salesordermap.put("saleSeq", "");
                    } else {
                        //将主键ID和物料编码存入集合
                        List<String> idList = new ArrayList<>();
                        //销售订单entryID
                        idList.add(list1.get(11).toString());
                        //行内码
                        SaleList.put(list1.get(12).toString(), idList);
                        //拼接id做批量查询
                        Sale = "'" + list1.get(11).toString() + "'," + Sale;
                    }
                    salesordermap.put("FSOEntryId", list1.get(11).toString());
                    salesordermap.put("FEntity_FEntryID", list1.get(12).toString());
//                    salesordermap.put("remark", list1.get(9).toString());
                    salesorderlist.add(salesordermap);
                }
                if (!"".equals(Sale)) {
                    //批量查出所有生产用料清单的数据
                    Sale = Sale.substring(0, Sale.length() - 1);
                    List<List<Object>> saleid = getSale(Sale);
                    if (null == saleid || "".equals(saleid.toString())) {
                        for (Map<String, String> salesordermap : salesorderlist) {
                            salesordermap.put("saleCode", "");
                            salesordermap.put("saleSeq", "");
                        }
                    } else {
                        //将集合赋值
                        for (String fid : SaleList.keySet()) {
                            for (List salelist : saleid) {
                                //如果对应的行内码相同
                                if (SaleList.get(fid).get(0).equals(salelist.get(1).toString())) {
                                    //将信息添加到集合
                                    SaleList.get(fid).add(salelist.get(0).toString());
                                    SaleList.get(fid).add(salelist.get(2).toString());
                                }
                            }
                        }
                        //将对应的信息写入到大集合
                        for (Map<String, String> salesordermap : salesorderlist) {
                            for (String fid : SaleList.keySet()) {
                                //如果行内码与父级ID都相同
                                if (fid.equals(salesordermap.get("FEntity_FEntryID")) && SaleList.get(fid).get(0).equals(salesordermap.get("FSOEntryId"))) {
                                    //如果对应的编码不为空
                                    if (null != SaleList.get(fid).get(1)) {
                                        salesordermap.put("saleCode", SaleList.get(fid).get(1));
                                        salesordermap.put("saleSeq", SaleList.get(fid).get(2));
                                    } else {
                                        salesordermap.put("saleCode", "");
                                        salesordermap.put("saleSeq", "");
                                    }
                                }
                            }
                        }
                    }
                }

            } else {
                //如果有错误信息则返回
                Map<String, Object> o = (Map<String, Object>) list.get(0).get(0);
                Object errors = o.get("Errors");
                List parse3 = (List) JSON.parse(errors.toString());
                Map parse4 = (Map) JSON.parse(parse3.get(0).toString());
                Object message = parse4.get("Message");
                Map<String, String> salesordermap = new HashMap<>();
                salesordermap.put("false", message.toString());
                salesorderlist.add(salesordermap);
            }
        }
        return salesorderlist;
    }

    @Override
    public String update(Object object) {
        return null;
    }
}
