package org.jeecg.modules.iost.ims.service.impl;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsBsSup;
import org.jeecg.modules.iost.ims.kingdeeapi.BsSupKingdeeApi;
import org.jeecg.modules.iost.ims.mapper.ImsBsSupMapper;
import org.jeecg.modules.iost.ims.service.IImsBsSupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.text.ParseException;
import java.util.*;

/**
 * @Description: 供应商基础信息
 * @Author: jeecg-boot
 * @Date:   2021-12-02
 * @Version: V1.0
 */
@Service
public class ImsBsSupServiceImpl extends ServiceImpl<ImsBsSupMapper, ImsBsSup> implements IImsBsSupService {

    @Autowired
    BsSupKingdeeApi kingdeeApi;
    @Autowired
    IMSApi imsApi;

    @Override
    public Boolean synchronization(Object object,LoginUser sysUser) throws ParseException {
        //追加参数(上下文对象)
        String kingdeeLogOZTName = "供应商基础信息";
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName",kingdeeLogOZTName);

        ImsLogUtil imsLogUtil=new ImsLogUtil();
        List<ImsBsSup> pojolist=new ArrayList<>();
        List<Map<String, String>> list=new ArrayList<>();
        List<Map<String, Object>> imsList=new ArrayList<>();
        Boolean success = false;
        Map<String,String> idmap=new HashMap<>();
        //设置需要同步的主键
        idmap.put("FSupplierId",object.toString());
        //将对应信息请求金蝶云
        list=kingdeeApi.select(idmap,null);

        List<Map<String,String>> bsList = new ArrayList<>();
        Map<String,Object> datalist=new HashMap<>();
        //遍历集合拿到所有的MAP
        for (Map<String, String> data : list) {
            //判断是否有错误
            if(data.containsKey("false")){
                return success;
            }
            //将实体信息记录下来
            ImsBsSup pojo = new ImsBsSup();
            pojo.setFid(data.get("fid"));
            pojo.setSupCode(data.get("supCode"));
            pojo.setSupName(data.get("supName"));
            pojo.setCountryCode(data.get("countryCode"));
            pojo.setContactsUser(data.get("contactsUser"));
            pojo.setContactsPhone(data.get("contactsPhone"));
            pojo.setCreateTime(new Date());
            if(sysUser!=null){
                pojo.setCreateBy(sysUser.getUsername());
                pojo.setSysOrgCode(sysUser.getOrgCode());
            }
            pojolist.add(pojo);
            //封装成IMS格式
            Map<String,String> bs_sup_dt=new HashMap<>();
            bs_sup_dt.put("contacts_user",data.get("contactsUser"));
            bs_sup_dt.put("contacts_phone",data.get("contactsPhone"));
            bs_sup_dt.put("contacts_email",data.get("contactsEmail"));
            bsList.add(bs_sup_dt);

            datalist.put("sup_code",data.get("supCode"));
            datalist.put("sup_name",data.get("supName"));
            datalist.put("country_code",data.get("countryCode"));
            datalist.put("remark","");
            imsList.add(datalist);
        }
        datalist.put("bs_sup_dt",bsList);
        this.saveBatch(pojolist);

        //将数据包装成IMS格式
        Map<String,Object> map=new HashMap<>();
        map.put("docType","BS_SUP");
        map.put("updateType","UPDATE");
        map.put("data",imsList);
        String mapjson = JsonUtil.Mapjson(map);
        String result = imsApi.add(mapjson, "供应商信息","BS_SUP");
        //记录IMS日志
        Boolean flag = imsLogUtil.ImsLog(mapjson,result, "供应商信息","BS_SUP",null);
        //设置同步成功状态
        success=flag;
        return success;
    }
}
