package org.jeecg.modules.iost.ims.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.exception.KingdeeRepeatException;
import org.jeecg.common.exception.kingdeeException;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.MapUtils;
import org.jeecg.modules.iost.ims.entity.ImsProduceOrderReady;
import org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.ErrorsInside;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsProduceOrderReadyApi;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsProduceOrderReadyOutApi;
import org.jeecg.modules.iost.ims.mapper.ImsProduceOrderReadyMapper;
import org.jeecg.modules.iost.ims.service.IImsProduceOrderReadyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;

/**
 * @Description: ImsProduceOrderReady  工单备料
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Service
public class ImsProduceOrderReadyServiceImpl extends ServiceImpl<ImsProduceOrderReadyMapper, ImsProduceOrderReady> implements IImsProduceOrderReadyService {
    @Autowired
    ImsProduceOrderReadyApi ImsProduceOrderReadyApi;
    private String imsLogName;
    private String DocType;
    private String SEQ;
    private String wipOrde;
    private String imsLogOZTNmae;

    private List<Map<String, Object>> needListsOut;
    private String codeOut;

    public ImsProduceOrderReadyServiceImpl() {
        this.imsLogName = "生产领料";  //ims日志-name(excal表里面金蝶那一列名字)
        this.imsLogOZTNmae = "工单备料";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "WMS0003";  //调用者传入的标识
        this.SEQ = "ERP_SEQ";  //父单据行号，一般默认是这个字符串(有些单据是AUDIT_SEQ)
        this.wipOrde = "MO_CODE";  //父亲单据工单编号或者行内码
    }

    public String setData(List<Map<String, Object>> needLists, String code) {
        List<Map<String, Object>> proList = new ArrayList<>();
        List<Map<String, Object>> outList = new ArrayList<>();
        String FbillNo = "";
        for (Map<String, Object> needMaps : needLists) {
            if ("N".equals(needMaps.get("IS_OUTS"))) {
                proList.add(needMaps);
            } else {
                outList.add(needMaps);
            }
        }
        if (!proList.isEmpty()) {
            int count = 1;
            needListsOut = needLists;
            codeOut = code;
            //追加参数(上下文对象)
            String kingdeeLogOZTName = ImsProduceOrderReadyApi.getKingdeeLogOZTName();
            Map map2 = ThreadLocalConfig.get();
            map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
            map2.put("SEQ", SEQ);
            map2.put("wipOrde", wipOrde);
            map2.put("count", count);
            ThreadLocalConfig.set(map2);
            //业务开始
            List<ImsProduceOrderReady> ImsProduceOrderReadys = new ArrayList<>();
            //查询父单据失败的lists
            List<Map<String, Object>> SelectFatherFentryIdFailLists = new ArrayList();
            //查询父单据失败的返回结果
            List<String> SelectFatherFentryIdFailResult = new ArrayList<>();
            //拼接唯一序号重复的返回结果
            List<String> queue_idRepeatResult = new ArrayList<>();
            //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
            ImsLogUtil imsLogUtil = new ImsLogUtil();
            imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, imsLogOZTNmae, DocType);
            List<String> qidList = new ArrayList<>();
            for (Map<String, Object> maps : needLists) {
                qidList.add(maps.get("QUEUE_ID").toString());
            }
            QueryWrapper<ImsProduceOrderReady> qw = new QueryWrapper();
            qw.in("queue_id", qidList);
            StringBuilder builder = new StringBuilder();
            int length = qidList.size();
            for (int i = 0; i < length; i++) {
                if (i == 0) {
                    builder.append("'" + qidList.get(i) + "'");
                } else {
                    builder.append(",").append("'" + qidList.get(i) + "'");
                }
            }
            qw.orderByAsc("FIELD(queue_id," + builder.toString() + ")");
            List<ImsProduceOrderReady> repeatLists = this.getBaseMapper().selectList(qw);
            if (!CollectionUtils.isEmpty(repeatLists)) {
                queue_idRepeatResult = ResultSplitOne(repeatLists);
            }
            if (!CollectionUtils.isEmpty(queue_idRepeatResult)) {
                throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0), code);
            }
            //判断需要修改的needLists里面有没有元素，有元素说明有东西未修改过，没有说明添加进来的数据都已经修改过了
            List<String> Father_FEntryIDs = new ArrayList<>();
            if (!ObjectUtils.isEmpty(needLists)) {
                Father_FEntryIDs = ImsProduceOrderReadyApi.queryFatherFEntryIDs(needLists, SelectFatherFentryIdFailLists);
                SelectFatherFentryIdFailResult = ResultSplitTwo(SelectFatherFentryIdFailLists);
            }
            if (!CollectionUtils.isEmpty(SelectFatherFentryIdFailResult)) {
                throw new kingdeeException("操作失败!", SelectFatherFentryIdFailResult, code);
            }
            //下推失败返回结果
            List<String> pushResultLists = new ArrayList<>();
            List<String> AddResultLists = new ArrayList();
            org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult = new org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result();
            if (!ObjectUtils.isEmpty(needLists)) {
                org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result result = ImsProduceOrderReadyApi.push(needLists, Father_FEntryIDs);
                pushResultLists = ResultSplitThree(result);
                if (!CollectionUtils.isEmpty(pushResultLists)) {
                    throw new kingdeeException("操作失败!下推失败!", pushResultLists, code);
                }
                //查询子单据行内码maps.get("AUDIT_ID").toString()+maps.get("AUDIT_SEQ").toString()
                for (Map<String, Object> needmap : needLists) {
                    String Son_FEntry_ID = ImsProduceOrderReadyApi.querySonFEntryID(needmap.get("ERP_SIC").toString(), needmap.get(SEQ).toString(), result.getResponseStatus().getSuccessEntitys().get(0).getId());
                    needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                    needmap.put("FEntry_ID", Son_FEntry_ID);

                }
                //修改成功下推后needPushLists的数据
                AddResult = ImsProduceOrderReadyApi.addTwo(needLists);
                if (AddResult.getResponseStatus().getIsSuccess()) {
                    for (Map<String, Object> needmap : needLists) {
                        needmap.put("FBILL_NO", AddResult.getNumber());
                        FbillNo = AddResult.getNumber();
                        //Map传入参数大写字段转化为实体类字段
                        Map<String, Object> map = MapUtils.mapsChange(needmap);
                        ImsProduceOrderReady ImsProduceOrderReady = JSON.parseObject(JSON.toJSONString(map), ImsProduceOrderReady.class);//map转为实体类对象
                        ImsProduceOrderReadys.add(ImsProduceOrderReady);
                    }
                }
                AddResultLists = ResultSplitFour(AddResult);
                if (!CollectionUtils.isEmpty(AddResultLists)) {
                    throw new kingdeeException("操作失败!修改失败!", AddResultLists, code);
                }
            }
            //保存实体类
            this.saveBatch(ImsProduceOrderReadys);
        }
        if (!outList.isEmpty()) {
            FbillNo = this.setDataOut(outList, codeOut);
        }
        return FbillNo;
    }

    public List<String> ResultSplitFour(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = AddResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = AddResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitThree(org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result pushResult) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        Boolean isSuccess = pushResult.getResponseStatus().getIsSuccess();
        if (!isSuccess) {
            List<ErrorsInside> errors = pushResult.getResponseStatus().getErrors();
            for (ErrorsInside error : errors) {
                rustList.add(error.getMessage());
            }
        }
        return rustList;
    }

    public List<String> ResultSplitTwo(List<Map<String, Object>> SelectFatherFentryIdFailLists) {
        String result = new String();
        List<String> rustList = new ArrayList<>();
        List<String> rustListAfter = new ArrayList<>();
        Map map = ThreadLocalConfig.get();
        Integer count = null;
        if (!ObjectUtils.isEmpty(map)) {
            count = Integer.valueOf(map.get("count").toString());
        }
        for (Map<String, Object> queue_idRepeatResultMap : SelectFatherFentryIdFailLists) {
            if (!ObjectUtils.isEmpty(queue_idRepeatResultMap.get("notExitFbillNo")) && Boolean.valueOf(queue_idRepeatResultMap.get("notExitFbillNo").toString()) == true) {
//                if(count==1)
//            {
//                this.setDataOut(needListsOut,codeOut);
//            }
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result = "行内码" + queue_idRepeatResultMap.get("ERP_SIC") + "不存在，无法进行下推修改!";
                rustList.add(result);
            } else {
                String queue_id = queue_idRepeatResultMap.get("QUEUE_ID").toString();
                result = "唯一序号为(" + queue_id + ")且行号为(" + queue_idRepeatResultMap.get(SEQ) + ")的数据不存在，无法进行下推修改!";
                rustList.add(result);
            }
        }
        HashSet<String> set = new LinkedHashSet();
        for (String s : rustList) {
            set.add(s);
        }
        for (String s : set) {
            rustListAfter.add(s);
        }
        return rustListAfter;
    }

    public List<String> ResultSplitOne(List<ImsProduceOrderReady> repeatLists) {
        String result = new String();
        LinkedHashSet<String> hashset = new LinkedHashSet<>();
        for (ImsProduceOrderReady ImsProduceOrderReady : repeatLists) {
            String queue_id = String.valueOf(ImsProduceOrderReady.getQueueId());
            result = "QUEUE_ID为(" + queue_id + ")的数据已经提交过!";
            hashset.add(result);
        }
        List<String> rustList = new ArrayList<>();
        String result2 = new String();
        for (String s : hashset) {
            rustList.add(s);
        }
        return rustList;
    }

    @Autowired
    ImsProduceOrderReadyOutApi imsProduceOrderReadyOutApi;

    public String setDataOut(List<Map<String, Object>> needLists, String code) {
        this.imsLogName = "委外领料";  //ims日志-name(excal表里面金蝶那一列名字)
        this.imsLogOZTNmae = "工单备料";//ims日志对应欧智通的标识字段(excal表里面欧智通那一列名字)
        this.DocType = "WMS0003";  //调用者传入的标识
        this.SEQ = "ERP_SEQ";  //父单据行号，一般默认是这个字符串(有些单据是AUDIT_SEQ)
        this.wipOrde = "MO_CODE";  //父亲单据工单编号或者行内码
        //追加参数(上下文对象)
        String kingdeeLogOZTName = imsProduceOrderReadyOutApi.getKingdeeLogOZTName();
        Map map2 = ThreadLocalConfig.get();
        map2.put("KingdeeLogOZTName", kingdeeLogOZTName);
        map2.put("SEQ", SEQ);
        map2.put("wipOrde", wipOrde);
        map2.put("count", "2");
        ThreadLocalConfig.set(map2);
        //业务开始
        List<ImsProduceOrderReady> ImsProduceOrderReadys = new ArrayList<>();
        //查询父单据失败的lists
        List<Map<String, Object>> SelectFatherFentryIdFailLists = new ArrayList();
        //查询父单据失败的返回结果
        List<String> SelectFatherFentryIdFailResult = new ArrayList<>();
        //拼接唯一序号重复的返回结果
        List<String> queue_idRepeatResult = new ArrayList<>();
        //请求参数的inputDTOXml里面json格式的参数传入ims同步日志(imslog)
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        imsLogUtil.ImsRequestLog(JSON.toJSONString(needLists), imsLogName, imsLogOZTNmae, DocType);
        List<String> qidList = new ArrayList<>();
        for (Map<String, Object> maps : needLists) {
            qidList.add(maps.get("QUEUE_ID").toString());
        }
        QueryWrapper<ImsProduceOrderReady> qw = new QueryWrapper();
        qw.in("queue_id", qidList);
        StringBuilder builder = new StringBuilder();
        int length = qidList.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append(qidList.get(i));
            } else {
                builder.append(",").append(qidList.get(i));
            }
        }
//        qw.orderByAsc("FIELD(queue_id,"+builder.toString()+")");
        List<ImsProduceOrderReady> repeatLists = this.getBaseMapper().selectList(qw);
        if (!CollectionUtils.isEmpty(repeatLists)) {
            queue_idRepeatResult = ResultSplitOne(repeatLists);
        }
        if (!CollectionUtils.isEmpty(queue_idRepeatResult)) {
            throw new KingdeeRepeatException("操作失败!", queue_idRepeatResult.get(0), code);
        }
        //判断需要修改的needLists里面有没有元素，有元素说明有东西未修改过，没有说明添加进来的数据都已经修改过了
        List<String> Father_FEntryIDs = new ArrayList<>();
        if (!ObjectUtils.isEmpty(needLists)) {
            Father_FEntryIDs = imsProduceOrderReadyOutApi.queryFatherFEntryIDs(needLists, SelectFatherFentryIdFailLists);
            SelectFatherFentryIdFailResult = ResultSplitTwo(SelectFatherFentryIdFailLists);
        }
        if (!CollectionUtils.isEmpty(SelectFatherFentryIdFailResult)) {
            throw new kingdeeException("操作失败!", SelectFatherFentryIdFailResult, code);
        }
        //下推失败返回结果
        List<String> pushResultLists = new ArrayList<>();
        List<String> AddResultLists = new ArrayList();
        org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result AddResult = new org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result();
        if (!ObjectUtils.isEmpty(needLists)) {
            org.jeecg.modules.iost.ims.entity.KingdeeResultObject.AddResultObject.Result result = imsProduceOrderReadyOutApi.push(needLists, Father_FEntryIDs);
            pushResultLists = ResultSplitThree(result);
            if (!CollectionUtils.isEmpty(pushResultLists)) {
                throw new kingdeeException("操作失败!下推失败!", pushResultLists, code);
            }
            //查询子单据行内码maps.get("AUDIT_ID").toString()+maps.get("AUDIT_SEQ").toString()
            for (Map<String, Object> needmap : needLists) {
                String Son_FEntry_ID = imsProduceOrderReadyOutApi.querySonFEntryID(needmap.get("ERP_SIC").toString(), needmap.get(SEQ).toString(), result.getResponseStatus().getSuccessEntitys().get(0).getId());
                needmap.put("FID", result.getResponseStatus().getSuccessEntitys().get(0).getId());
                needmap.put("FEntry_ID", Son_FEntry_ID);
            }
            //修改成功下推后needPushLists的数据
            AddResult = imsProduceOrderReadyOutApi.addTwo(needLists);
            if (AddResult.getResponseStatus().getIsSuccess()) {
                for (Map<String, Object> needmap : needLists) {
                    needmap.put("FBILL_NO", AddResult.getNumber());
                    //Map传入参数大写字段转化为实体类字段
                    Map<String, Object> map = MapUtils.mapsChange(needmap);
                    ImsProduceOrderReady ImsProduceOrderReady = JSON.parseObject(JSON.toJSONString(map), ImsProduceOrderReady.class);//map转为实体类对象
                    ImsProduceOrderReadys.add(ImsProduceOrderReady);
                }
            }
            AddResultLists = ResultSplitFour(AddResult);
            if (!CollectionUtils.isEmpty(AddResultLists)) {
                throw new kingdeeException("操作失败!修改失败!", AddResultLists, code);
            }
        }
        //保存实体类
        this.saveBatch(ImsProduceOrderReadys);
        return ImsProduceOrderReadys.get(0).getFbillNo();
    }
}
