package org.jeecg;


import kingdee.bos.webapi.client.K3CloudApiClient;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.jeecg.common.util.security.SecurityTools;
import org.jeecg.common.util.security.entity.*;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;

@Slf4j
@EnableScheduling
public class SecurityToolsTest {
    @Test
    public void Test() {
        MyKeyPair mkeyPair = SecurityTools.generateKeyPair();

        JSONObject msg = new JSONObject();
        msg.put("name", "党政辉");
        msg.put("age", 50);
        JSONObject identity = new JSONObject();
        identity.put("type", "01");
        identity.put("no", "210882165896524512");
        msg.put("identity", identity);

        // 签名加密部分
        SecuritySignReq signReq = new SecuritySignReq();
        // data为要加密的报文字符串
        signReq.setData(msg.toString());
        // 为rsa私钥
        signReq.setPrikey(mkeyPair.getPriKey());
        // 调用签名方法
        SecuritySignResp sign = SecurityTools.sign(signReq);
        // 打印出来加密数据
        // signData为签名数据
        // data为aes加密数据
        // asekey为ras加密过的aeskey
        //System.out.println(new JSONObject(sign).toStringPretty());

        // 验签解密部分
        SecurityReq req = new SecurityReq();
        //对方传过来的数据一一对应
        req.setAesKey(sign.getAesKey());
        req.setData(sign.getData());
        req.setSignData(sign.getSignData());
        //我们的公钥
        req.setPubKey(mkeyPair.getPubKey());
        //验签方法调用
        SecurityResp securityResp = SecurityTools.valid(req);
        //解密报文data为解密报文
        //sucess 为验签成功失败标志 true代码验签成功，false代表失败 w
        // System.out.println(new JSONObject(securityResp).toStringPretty());
    }

    @Autowired
    CategoryDao categoryDao;

    /*/D:/gitCode/OZT-Integration/jeecg-boot-module-system/target/test-classes/*/
    @Test
    public void testUpdate() {
        String K3CloudURL = "http://192.168.2.26/k3cloud/";
        String dbId = "6221b5ff539caa";
        String uid = "ad";
        String pwd = "666666";
        int lang = 2052;
        K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            System.out.println(result);
            if (result) {
                String content = "UPDATE T_PRD_MOENTRY SET F_LQKJ_IMSSTATUS = 1 WHERE FID = 100014 AND FSEQ = 1";

                String[] strings = new String[]{content};
                System.out.println("content " + content);
                String list = client.execute("LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub", strings, String.class);
                System.out.println(list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSelect() {
        String K3CloudURL = "http://192.168.2.26/k3cloud/";
        String dbId = "6221b5ff539caa";
        String uid = "ad";
        String pwd = "666666";
        int lang = 2052;
        K3CloudApiClient client = new K3CloudApiClient(K3CloudURL);

        try {
            Boolean result = client.login(dbId, uid, pwd, lang);
            if (result) {
                String content = "SELECT * FROM T_PRD_MOENTRY WHERE FID = 100014 AND FSEQ = 1";
                //content = "SELECT * FROM T_PRD_MO;";

                String[] strings = new String[]{content};
                System.out.println("content " + content);
                String list = client.execute("LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub", strings, String.class);
                System.out.println(list);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
