/*
 * Decompiled with CFR 0.152.
 */
package com.lingqingkeji.integration.adapterframework.response;

public class RestResponse {
    public static final int CODE_SUCCESS = 200;
    public static final int CODE_VERSION_NONSUPPORT = 305;
    public static final int CODE_PARAM_ERROR = 400;
    public static final int CODE_TOKEN_EXPIRED = 402;
    public static final int CODE_TOKEN_NOTFOUND = 403;
    public static final int CODE_FORBIDDEN = 406;
    public static final int CODE_SERVER_ERROR = 500;
    private int code;
    private String message;
    private Object data = null;

    public static RestResponse success() {
        RestResponse restResponse = new RestResponse();
        restResponse.setCode(200);
        return restResponse;
    }

    public static RestResponse success(Object data) {
        RestResponse restResponse = new RestResponse();
        restResponse.setCode(200);
        restResponse.setData(data);
        return restResponse;
    }

    public static RestResponse fail(int code, String msg) {
        RestResponse restResponse = new RestResponse();
        restResponse.setCode(code);
        restResponse.setMessage(msg);
        return restResponse;
    }

    public static RestResponse fail(String msg) {
        return RestResponse.fail(400, msg);
    }

    public static RestResponse fail(String msg, Object data) {
        RestResponse restResponse = new RestResponse();
        restResponse.setCode(400);
        restResponse.setMessage(msg);
        restResponse.setData(data);
        return restResponse;
    }

    public static RestResponse error(String msg) {
        RestResponse restResponse = new RestResponse();
        restResponse.setCode(500);
        restResponse.setMessage(msg);
        return restResponse;
    }

    public boolean isSuccess() {
        return 200 == this.code;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestResponse)) {
            return false;
        }
        RestResponse other = (RestResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "RestResponse(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

