/*
 * Decompiled with CFR 0.152.
 */
package com.lingqingkeji.integration.adapterframework.utils;

import com.lingqingkeji.integration.adapterframework.handler.FacePlusThrowErrorHandler;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final int CONN_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    private static RestTemplate restTemplate;

    private static HttpHeaders initHeader() {
        HttpHeaders headers = new HttpHeaders();
        return headers;
    }

    private static void setHeaderParam(HttpHeaders httpHeaders, Map<String, Object> headers) {
        if (!CollectionUtils.isEmpty(headers)) {
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                httpHeaders.add(key, headers.get(key).toString());
            }
        }
    }

    public static ResponseEntity<String> httpGet(String url) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        return restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
    }

    public static ResponseEntity<String> httpGet(String url, Map<String, Object> param) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        url = HttpUtil.setParam(url, param);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        return restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
    }

    private static String setParam(String url, Map<String, Object> param) {
        Set<String> keys = param.keySet();
        StringBuilder builder = new StringBuilder();
        builder.append("?");
        for (String key : keys) {
            builder.append(key).append("=").append(param.get(key)).append("&");
        }
        builder.deleteCharAt(builder.lastIndexOf("&"));
        url = url + builder.toString();
        return url;
    }

    public static ResponseEntity<String> httpGet(String url, Map<String, Object> param, Map<String, Object> headers) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        if (!CollectionUtils.isEmpty(headers)) {
            HttpUtil.setHeaderParam(httpHeaders, headers);
        }
        if (!CollectionUtils.isEmpty(param)) {
            url = HttpUtil.setParam(url, param);
        }
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
        return restTemplate.exchange(url, HttpMethod.GET, httpEntity, String.class, new Object[0]);
    }

    public static ResponseEntity<String> httpPost(String url, String json) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        return HttpUtil.toPost(url, httpHeaders, json);
    }

    public static ResponseEntity<String> httpPost(String url, Map<String, Object> header, String json) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        HttpUtil.setHeaderParam(httpHeaders, header);
        return HttpUtil.toPost(url, httpHeaders, json);
    }

    private static ResponseEntity<String> toPost(String url, HttpHeaders httpHeaders, String json) {
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)httpHeaders);
        return restTemplate.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
    }

    public static byte[] download(String url, String json) {
        HttpHeaders httpHeaders = HttpUtil.initHeader();
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)httpHeaders);
        return (byte[])restTemplate.exchange(url, HttpMethod.POST, httpEntity, byte[].class, new Object[0]).getBody();
    }

    static {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(10000);
        requestFactory.setReadTimeout(10000);
        restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.setErrorHandler((ResponseErrorHandler)new FacePlusThrowErrorHandler());
    }
}

