/*
 * Decompiled with CFR 0.152.
 */
package com.lingqingkeji.integration.adapterframework.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("Json\u89e3\u6790\u51fa\u9519\uff1a JsonUtil.toString(), Json: " + obj);
            return "";
        }
    }

    public static <T> T toBean(String json, Class<T> tClass) {
        try {
            return (T)MAPPER.readValue(json, tClass);
        }
        catch (IOException e) {
            log.error("Json\u89e3\u6790\u51fa\u9519\uff1a JsonUtil.toBean(), Json: " + json);
            T t = null;
            try {
                t = tClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                ex.printStackTrace();
            }
            return t;
        }
    }

    public static <E> List<E> toList(String json, Class<E> eClass) {
        try {
            return (List)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructCollectionType(List.class, eClass));
        }
        catch (IOException e) {
            log.error("Json\u89e3\u6790\u51fa\u9519\uff1a JsonUtil.toList(), Json: " + json);
            return new ArrayList();
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> kClass, Class<V> vClass) {
        try {
            return (Map)MAPPER.readValue(json, (JavaType)MAPPER.getTypeFactory().constructMapType(Map.class, kClass, vClass));
        }
        catch (IOException e) {
            log.error("Json\u89e3\u6790\u51fa\u9519\uff1a JsonUtil.toMap(), Json: " + json);
            return new HashMap(10);
        }
    }

    public static <T> T nativeRead(String json, TypeReference<T> type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            log.error("Json\u89e3\u6790\u51fa\u9519\uff1a JsonUtil.nativeRead(), Json: " + json);
            return null;
        }
    }
}

