package org.jeecg.common.exception;

import lombok.Data;

import java.util.List;

/**
 * 金蝶云操作异常
 */
@Data
public class kingdeeException extends RuntimeException {
    public String result;
    public String code;

    public kingdeeException(String message, List<String> result, String code) {
        super(message);
        StringBuilder builder = new StringBuilder();
        int length = result.size();
        for (int i = 0; i < length; i++) {
            if (i == 0) {
                builder.append(result.get(i));
            } else {
                builder.append("  ").append(result.get(i));
            }
        }
        this.result = builder.toString();
        this.code = code;
    }

    public kingdeeException(String message, String result, String code) {
        super(message);
        this.result = result;
        this.code = code;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
