package org.jeecg.modules.iost.ims.ExternalInterface;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.exception.imsConnectException;
import org.jeecg.modules.iost.ims.ExternalInterface.Interface.API;
import org.jeecg.modules.iost.ims.TimeTask.DelayedTask;
import org.jeecg.modules.iost.ims.Util.HttpUtil;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.controller.WebApi;
import org.jeecg.modules.iost.ims.entity.ImsInitConnectParm;
import org.jeecg.modules.iost.ims.service.IImsInitConnectParmService;
import org.jeecg.modules.quartz.entity.QuartzJob;
import org.jeecg.modules.quartz.service.IQuartzJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.DelayQueue;

/**
 * @Description: IMS连接
 */
@Service
@Data
@Slf4j
public class IMSApi implements API {
    /*private String url = "http://192.168.2.237:8899/soap/IWebService";*/
    private String url;
    private ImsInitConnectParm imsInitConnectParm;
    static int num = 0;
    private List<Map<String, Object>> lists = new ArrayList<Map<String, Object>>();
    @Autowired
    IImsInitConnectParmService iImsInitConnectParmService;
    @Autowired
    WebApi webApi;
    @Autowired
    private IQuartzJobService quartzJobService;
    @Autowired
    IQuartzJobService iQuartzJobService;

    @PostConstruct
    public void init() {
        imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        url = imsInitConnectParm.getUrl();
    }

    public String add(String InputDTOXml, String name, String code) {
        String result = null;
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        try {
            result = HttpUtil.postJson(this.url, InputDTOXml);
        } catch (IOException e) {
            num++;
            imsLogUtil.ImsLog(InputDTOXml, result, name, code, e.toString());
            if (num == 3) {
                num = 0;
                QuartzJob job = null;
                job = quartzJobService.getOne(new LambdaQueryWrapper<QuartzJob>().eq(QuartzJob::getJobClassName, "org.jeecg.modules.quartz.job.imsSymJob"));
                quartzJobService.pause(job);
                log.info("停止自动同步");
                DelayQueue<DelayedTask> delayQueue = new DelayQueue<DelayedTask>();
                DelayedTask task1 = new DelayedTask(60 * 60);
                delayQueue.add(task1);
                while (delayQueue.size() != 0) {
                    DelayedTask task = delayQueue.poll();
                    if (task != null) {
                        QuartzJob job1 = null;
                        job1 = quartzJobService.getOne(new LambdaQueryWrapper<QuartzJob>().eq(QuartzJob::getJobClassName, "org.jeecg.modules.quartz.job.imsSymJob"));
                        quartzJobService.resumeJob(job1);
                        log.info("开启自动同步");
                    }
                }
            }

            throw new imsConnectException("ims连接失败,请检查ims参数");
        }

        return result;
    }

    /**
     * 调用IMS删除出库单接口
     * @param InputDTOXml
     * @param name
     * @param code
     * @return
     */
    public String delete(String InputDTOXml,String name, String code){
        String result = null;
        ImsLogUtil imsLogUtil = new ImsLogUtil();
        try {
            result = HttpUtil.postJson(this.url, InputDTOXml);
        } catch (Exception e) {
            imsLogUtil.ImsLog(InputDTOXml, result, name, code, "调用IMS删除出库单接口异常,异常信息为:"+e.toString());
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public String add(Map<String, String> map) {
        String result = null;

        try {
            result = HttpUtil.post(this.url, JsonUtil.Mapjson(map));
        } catch (IOException e) {
            throw new imsConnectException("ims连接失败,请检查ims参数");
        }
        return result;
    }

    @Override
    public String select() {
        return null;
    }

}
