package org.jeecg.modules.iost.ims.Util;

import com.alibaba.fastjson.JSON;
import org.jeecg.modules.iost.ims.entity.Imslog;
import org.jeecg.modules.iost.ims.service.IImslogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.Map;

/**
 * IMS日志工具
 */
@Component
public class ImsLogUtil {
    @Autowired
    IImslogService iImslogService;

    //单例模式
    private static ImsLogUtil uploadRooms;

    //服务器加载Servlet的时候运行，并且只会被服务器执行一次。PostConstruct在构造函数之后执行，init（）方法之前执行。
    @PostConstruct
    public void init() {
        uploadRooms = this;
        uploadRooms.iImslogService = this.iImslogService;
    }

    //添加IMS响应日志
    public Boolean ImsLog(String request, String result, String name, String code, String message) {
        Imslog imslog = new Imslog();
        Boolean flag = false;
        if (null != result) {
            Map maps = (Map) JSON.parse(result);
            //设置日志信息
            imslog.setName(name);
            imslog.setRequest(request);
            imslog.setMessage((String) maps.get("resultMsg"));
            imslog.setResponse(result);
            imslog.setCreateTime(new Date());
            imslog.setCode(code);
            if (maps.get("resultCode").toString().equals("0000")) {
                flag = true;
                imslog.setSuccess("true");
            } else if (maps.get("resultCode").toString().equals("0001")) {
                flag = true;
                imslog.setSuccess("Partial success");
            } else {
                imslog.setSuccess("false");
            }
        } else {
            //设置日志信息
            imslog.setName(name);
            imslog.setRequest(request);
            imslog.setMessage(message);
            imslog.setResponse("");
            imslog.setCreateTime(new Date());
            imslog.setCode(code);
            imslog.setSuccess("false");
        }
        ImsLogUtil.uploadRooms.iImslogService.save(imslog);
        return flag;
    }

    /**
     * 设置IMS请求日志
     *
     * @param data
     * @param name
     */
    public void ImsRequestLog(String data, String name, String OZTname, String code) {
        Imslog imslog = new Imslog();
        imslog.setCode(code);
        imslog.setName(name);
        imslog.setSuccess("true");
        imslog.setRequest(data);
        imslog.setCreateTime(new Date());
        imslog.setOztName(OZTname);
        ImsLogUtil.uploadRooms.iImslogService.save(imslog);
    }
}
