package org.jeecg.modules.iost.ims.client;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.lingqingkeji.integration.adapterframework.vo.IntegrateBaseOutVo;
import kingdee.bos.webapi.client.ApiHttpClient;
import kingdee.bos.webapi.client.ApiRequest;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.client.SerializerProxy;
import org.jeecg.modules.iost.ims.kingdeeadapter.KingDeeUtil;
import org.jeecg.modules.iost.ims.kingdeeadapter.constants.Constants;
import org.jeecg.modules.iost.ims.kingdeeadapter.constants.KingDeeConstants;
import org.jeecg.modules.iost.ims.kingdeeapi.HttpUtil;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.Instant;
import java.util.*;

/**
 * @author Inori
 */
@Slf4j
public class KingdeeApiClient {

    /**
     * 金蝶地址
     */
    private String serverUrl;

    /**
     * Cookie
     */
    private String cookieStore;
    /**
     * token
     */
    private String userToken;
    /**
     * 金蝶后缀
     */
    private static final String HTTP_SUFFIX = ".common.kdsvc";


    public KingdeeApiClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @SuppressWarnings("unchecked")
    public <T> T execute(String serviceName, Object parameters, Class<T> returnType) throws Exception {
        Map map2 = ThreadLocalConfig.get();
        if (ObjectUtils.isEmpty(map2)) {
            map2 = new HashMap();
            map2.put("don_delete!", "don_delete!");
        }

        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookieStore);

        Map<String, Object> request = new HashMap<>(1);
        request.put("parameters", parameters);

        String url = serverUrl + serviceName + HTTP_SUFFIX;
        log.info("servicename_"+serviceName);
        log.info("serverUrl_"+this.serverUrl);
        long start = System.currentTimeMillis();
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, JsonUtil.toString(request));
        long costTime = System.currentTimeMillis() - start;
        log.info("Costime_"+String.valueOf(costTime));
        if (!ObjectUtils.isEmpty(map2)) {
            map2.put("Costime", costTime);
            ThreadLocalConfig.set(map2);
        }
        Map<String, Object> map = ThreadLocalConfig.get();
        map.put("costTime", costTime);
        ThreadLocalConfig.set(map);

        return (T) (new SerializerProxy()).deserialize(responseEntity.getBody(), returnType);
    }

    @SuppressWarnings("unchecked")
    public <T> T execute(String serviceName, Object[] parameters, Class<T> returnType, IntegrateBaseOutVo integrateBaseOutVo) throws Exception {
        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookieStore);
        Map<String, Object> request = new HashMap<>(1);
        request.put("parameters", parameters);

        String url = serverUrl + serviceName + HTTP_SUFFIX;

        long start = System.currentTimeMillis();
        integrateBaseOutVo.getTimeList().add(Instant.now());
        integrateBaseOutVo.getTimeStrList().add("获取数据开始：" + Instant.now().toString());
        integrateBaseOutVo.getOriginalUrl().add(url);
        String requestStr = JsonUtil.toString(request);
        integrateBaseOutVo.getOriginalRequest().add(requestStr);
//        System.out.printf(requestStr);
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, requestStr);
        integrateBaseOutVo.getTimeList().add(Instant.now());
        integrateBaseOutVo.getTimeStrList().add("获取数据结束：" + Instant.now().toString());
        integrateBaseOutVo.getOriginalResult().add(responseEntity.getBody());
        long costTime = System.currentTimeMillis() - start;

        Map<String, Object> map = ThreadLocalConfig.get();
        map.put("costTime", costTime);
        ThreadLocalConfig.set(map);

        return (T) (new SerializerProxy()).deserialize(responseEntity.getBody(), returnType);
    }

    @SuppressWarnings("unchecked")
    public <T> T execute(String serviceName, Object parameters, Class<T> returnType, IntegrateBaseOutVo integrateBaseOutVo) throws Exception {
        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookieStore);
        String url = serverUrl + serviceName + HTTP_SUFFIX;

        long start = System.currentTimeMillis();
        integrateBaseOutVo.getTimeList().add(Instant.now());
        integrateBaseOutVo.getTimeStrList().add("获取数据开始：" + Instant.now().toString());
        integrateBaseOutVo.getOriginalUrl().add(url);
        String requestStr = JsonUtil.toString(parameters);
        integrateBaseOutVo.getOriginalRequest().add(requestStr);
//        System.out.printf(requestStr);
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, requestStr);
        integrateBaseOutVo.getTimeList().add(Instant.now());
        integrateBaseOutVo.getTimeStrList().add("获取数据结束：" + Instant.now().toString());
        integrateBaseOutVo.getOriginalResult().add(responseEntity.getBody());
        long costTime = System.currentTimeMillis() - start;

        Map<String, Object> map = ThreadLocalConfig.get();
        map.put("costTime", costTime);
        ThreadLocalConfig.set(map);

        return (T) (new SerializerProxy()).deserialize(responseEntity.getBody(), returnType);
    }

    @SuppressWarnings("unchecked")
    public <T> T getData(String serviceName, Class<T> returnType, IntegrateBaseOutVo integrateBaseOutVo) throws Exception {
        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookieStore);

        String url = serverUrl + serviceName + HTTP_SUFFIX;

        long start = System.currentTimeMillis();
        integrateBaseOutVo.getTimeList().add(Instant.now());
        integrateBaseOutVo.getTimeStrList().add("获取数据开始：" + Instant.now().toString());
        integrateBaseOutVo.getOriginalUrl().add(url);
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, "{}");
        integrateBaseOutVo.getTimeList().add(Instant.now());
        integrateBaseOutVo.getTimeStrList().add("获取数据结束：" + Instant.now().toString());
        integrateBaseOutVo.getOriginalResult().add(responseEntity.getBody());
        long costTime = System.currentTimeMillis() - start;

        Map<String, Object> map = ThreadLocalConfig.get();
        map.put("costTime", costTime);
        ThreadLocalConfig.set(map);

        return (T) (new SerializerProxy()).deserialize(responseEntity.getBody(), returnType);
    }


    public Boolean login(String dbId, String userName, String password, int lcid, IntegrateBaseOutVo integrateBaseOutVo) {
        try {
            String cookieKey = KingDeeUtil.createCookieKey(dbId, userName, password, lcid);
            if (RedisUtil.hasKey(cookieKey)) {
                this.cookieStore = (String) RedisUtil.get(cookieKey);
                return true;
            }
            Map<String, Object> request = new HashMap<>(1);
            request.put("parameters", new Object[]{dbId, userName, password, lcid});

            if (!serverUrl.endsWith("/")) {
                serverUrl += "/";
            }
            String url = serverUrl + "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser" + HTTP_SUFFIX;

            integrateBaseOutVo.getTimeList().add(Instant.now());
            integrateBaseOutVo.getTimeStrList().add("登录开始：" + Instant.now().toString());
            integrateBaseOutVo.getOriginalUrl().add(url);
            String requestStr = JsonUtil.toString(request);
            integrateBaseOutVo.getOriginalRequest().add(requestStr);
            ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, requestStr);
            integrateBaseOutVo.getTimeList().add(Instant.now());
            integrateBaseOutVo.getTimeStrList().add("登录结束：" + Instant.now().toString());
            integrateBaseOutVo.getOriginalResult().add(responseEntity.getBody());


            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                Map<String, Object> map = JsonUtil.toMap(responseEntity.getBody(), String.class, Object.class);
                if (!CollectionUtils.isEmpty(map) && Constants.ONE.equals(Integer.parseInt(String.valueOf(map.get(KingDeeConstants.LOGIN_RESULT_TYPE))))) {
                    LinkedHashMap<String, Object> Context = (LinkedHashMap<String, Object>) map.get("Context");
                    this.cookieStore = this.getCookieStore(responseEntity);
                    this.userToken = String.valueOf(Context.get("UserToken"));
                    RedisUtil.set(cookieKey, cookieStore, KingDeeUtil.getCookieKeyOutTime());
                    RedisUtil.set("userToken", userToken);
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
    public Boolean login(String dbId, String userName, String password, int lcid) {
        try {
            String cookieKey = KingDeeUtil.createCookieKey(dbId, userName, password, lcid);
            if (RedisUtil.hasKey(cookieKey)) {
                this.cookieStore = (String) RedisUtil.get(cookieKey);
                return true;
            }
            Map<String, Object> request = new HashMap<>(1);
            request.put("parameters", new Object[]{dbId, userName, password, lcid});

            if (!serverUrl.endsWith("/")) {
                serverUrl += "/";
            }
            String url = serverUrl + "Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser" + HTTP_SUFFIX;
            String requestStr = JsonUtil.toString(request);
            ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, requestStr);
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                Map<String, Object> map = JsonUtil.toMap(responseEntity.getBody(), String.class, Object.class);
                if (!CollectionUtils.isEmpty(map) && Constants.ONE.equals(Integer.parseInt(String.valueOf(map.get(KingDeeConstants.LOGIN_RESULT_TYPE))))) {
                    LinkedHashMap<String, Object> Context = (LinkedHashMap<String, Object>) map.get("Context");
                    this.cookieStore = this.getCookieStore(responseEntity);
                    this.userToken = String.valueOf(Context.get("UserToken"));
                    RedisUtil.set(cookieKey, cookieStore, KingDeeUtil.getCookieKeyOutTime());
                    RedisUtil.set("userToken", userToken);
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
    private String getCookieStore(String cookieKey) {
        return null;
    }

    private String getCookieStore(ResponseEntity<String> responseEntity) {
        String cookieStore = "";
        Set<String> keys = responseEntity.getHeaders().keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase(KingDeeConstants.KING_DEE_COOKIE_NAME)) {
                List<String> cookieList = responseEntity.getHeaders().get(key);
                if (!CollectionUtils.isEmpty(cookieList)) {
                    for (String cookie : cookieList) {
                        if (cookie.startsWith(KingDeeConstants.KING_DEE_SESSION_NAME)) {
                            cookieStore = cookie;
                            break;
                        }
                    }
                }
            }
        }
        return cookieStore;
    }

}
