package org.jeecg.modules.iost.ims.client;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.google.gson.Gson;
import kingdee.bos.json.JSONObject;
import kingdee.bos.webapi.client.ApiHttpClient;
import kingdee.bos.webapi.client.ApiRequest;
import kingdee.bos.webapi.client.ApiServiceRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.CookieStore;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.HttpUtil;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class KingdeeApiClientOld {
    private String _serverUrl;
    private CookieStore _cookieStore;

    public KingdeeApiClientOld(String serverUrl) {
        this._serverUrl = serverUrl;
    }

    public static void main(String[] args) {
        Gson gson = new Gson();
        String json = "[{\"Result\":{\"ResponseStatus\":{\"IsSuccess\":true,\"Errors\":[],\"SuccessEntitys\":[{\"Id\":217387,\"Number\":\"ZJDB102867\",\"DIndex\":0}],\"SuccessMessages\":[],\"MsgCode\":0},\"Id\":217387,\"Number\":\"ZJDB102867\",\"NeedReturnData\":[{}]}}]";
        String s1 = com.alibaba.fastjson.JSONObject.parseObject(json, String.class);
        System.out.println(s1);
        Object s = gson.fromJson(json, List.class);
        System.out.println(s);
    }
    public <T> ApiRequest<T> createRequest(String servicename, Object[] parameters, Class<T> returnType) {
        return new ApiServiceRequest(this._serverUrl, this._cookieStore, servicename, parameters, returnType);
    }

    public <T> T execute(String servicename, Object[] parameters, Class<T> returnType) throws Exception {

        //execute(servicename, parameters);

        Map map2 = ThreadLocalConfig.get();
        if (ObjectUtils.isEmpty(map2)) {
            map2 = new HashMap();
            map2.put("don_delete!", "don_delete!");
        }

        log.info("servicename_"+servicename);
        log.info("serverUrl_"+this._serverUrl);
        ApiRequest<T> request = this.createRequest(servicename, parameters, returnType);
        ApiHttpClient<T> httpClient = new ApiHttpClient();
        request.setListener(httpClient);
        long beginTime = System.currentTimeMillis();
        T send = httpClient.Send(request, returnType);
        long Costime = System.currentTimeMillis() - beginTime;
        log.info("Costime_"+String.valueOf(Costime));
        if (!ObjectUtils.isEmpty(map2)) {
            map2.put("Costime", Costime);
            ThreadLocalConfig.set(map2);
        }

        
        return send;
    }

    public void execute(String serviceName, Object[] parameters) throws Exception {
    	
    	String cookie = HttpUtil.login(this._serverUrl);
    	log.info("cookie:" + cookie);
        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookie);

        Map<String, Object> request = new HashMap<>(1);
        request.put("parameters", parameters);

        String url = this._serverUrl + serviceName + ".common.kdsvc";

        long start = System.currentTimeMillis();
        String requestStr = JsonUtil.toString(request);
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, requestStr);
        long costTime = System.currentTimeMillis() - start;
        log.info("Costime2_"+String.valueOf(costTime));

        log.info("Body_"+responseEntity.getBody());
    }

//    public <T> ApiRequest<T> executeAsync(String servicename, Object[] parameters, Class<T> returnType, IAsyncActionCallBack<T> callback) throws Exception {
//        ApiRequest<T> request = this.createRequest(servicename, parameters, returnType);
//        ApiHttpClient<T> httpClient = new ApiHttpClient(callback);
//        request.setListener(httpClient);
//        httpClient.syncSend(request);
//        return request;
//    }

    public Boolean login(String dbId, String userName, String password, int lcid) throws Exception {
        try {
            Object[] loginInfo = new Object[]{dbId, userName, password, lcid};
            ApiRequest<String> request = this.createRequest("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
            ApiHttpClient<String> httpClient = new ApiHttpClient();
            request.setListener(httpClient);
            String ret = (String) httpClient.Send(request, String.class);
            System.out.println(ret);
            int result = (new JSONObject(ret)).getInt("LoginResultType");
            if (result == 1) {
                this._cookieStore = request.getCookieStore();
                return true;
            } else {
                return false;
            }
        } catch (Exception var10) {
            var10.printStackTrace();
            return false;
        }
    }
}
