package org.jeecg.modules.iost.ims.client;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.kingdee.bos.webapi.entity.IdentifyInfo;
import com.kingdee.bos.webapi.entity.RepoResult;
import com.kingdee.bos.webapi.entity.RepoStatus;
import com.kingdee.bos.webapi.sdk.K3CloudApi;
import kingdee.bos.json.JSONObject;
import kingdee.bos.webapi.client.ApiHttpClient;
import kingdee.bos.webapi.client.ApiRequest;
import kingdee.bos.webapi.client.ApiServiceRequest;
import kingdee.bos.webapi.client.IAsyncActionCallBack;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.client.CookieStore;
import org.jeecg.common.util.ThreadLocalConfig;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.kingdeeapi.HttpUtil;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.Map;

@Slf4j
public class KingdeeApiClientSDK {
    private String _serverUrl;
    private K3CloudApi api;

    public KingdeeApiClientSDK(String serverUrl) {
        this._serverUrl = serverUrl;
    }

    public <T> T execute(String servicename, Object[] parameters, Class<T> returnType) throws Exception {
        execute(servicename, parameters);
        long startTime = System.currentTimeMillis();
        T execute = api.execute(servicename, parameters, returnType);
        long duration = System.currentTimeMillis() - startTime;
        log.info("<======sdk请求耗时：" + duration + "毫秒");
        return execute;
    }

    public void execute(String serviceName, Object[] parameters) throws Exception {

        String cookie = HttpUtil.login(this._serverUrl);
        log.info("cookie:" + cookie);
        Map<String, Object> header = new HashMap<>(1);
        header.put("cookie", cookie);
        Map<String, Object> request = new HashMap<>(1);
        request.put("parameters", parameters);
        String url = this._serverUrl + serviceName + ".common.kdsvc";
        String requestStr = JsonUtil.toString(request);
        long start = System.currentTimeMillis();
        ResponseEntity<String> responseEntity = HttpUtil.httpPost(url, header, requestStr);
        long costTime = System.currentTimeMillis() - start;
        log.info("<======模拟http耗时：" + String.valueOf(costTime));

        log.info("Body_" + responseEntity.getBody());
    }

    public String checkAuthInfo() {
        try {

            String s = api.CheckAuthInfo().getResult().toString();
            System.out.println("<=====检测登录状态: " + s);
            return s;
        } catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public static void main(String[] args) throws Exception {
        IdentifyInfo identifyInfo = new IdentifyInfo() {
        };
        identifyInfo.setAppId("232190_5d4pQbjpRvp86VypX3TD1dXJUKXc4ppo");
        identifyInfo.setAppSecret("7e4a4779a554403eb2189bf3841552e3");
        identifyInfo.setServerUrl("http://10.10.1.212/k3cloud");
        identifyInfo.setdCID("62f50a9ea1ece4");
        identifyInfo.setlCID(2052);
        identifyInfo.setUserName("MES");
        System.out.println("开始");
        K3CloudApi api = new K3CloudApi(identifyInfo);
        RepoResult repoResult = api.CheckAuthInfo();
        RepoStatus responseStatus = repoResult.getResponseStatus();
        System.out.println(":" + repoResult.getResult());
        System.out.println("is" + responseStatus.isIsSuccess());

    }

    public Boolean login(String dbId, String userName, String password, int lcid) throws Exception {
        try {
            IdentifyInfo iden = new IdentifyInfo();
            iden.setUserName("admin");
            iden.setAppId("267026_TedP2+lJznBfWUXEX4SB78+L4J07QsKo");
            iden.setAppSecret("0ea786a865ef4413923b1367de5408aa");
            iden.setdCID("6476c5b6077e71");
            iden.setlCID(2052);
            iden.setServerUrl(_serverUrl);
            api = new K3CloudApi(iden);
//            String data = "{\"CreateOrgId\": 0,\"Number\": \"111\",\"Id\": \"\",\"IsSortBySeq\": \"false\"}";
//            String result = api.view("BD_Material", data);
//            System.out.println("<=====test:" + result);
            RepoResult repoResult = api.CheckAuthInfo();
            RepoStatus responseStatus = repoResult.getResponseStatus();
            boolean isSuccess = responseStatus.isIsSuccess();
            System.out.println("<=====登录状态:" + isSuccess);
            System.out.println("<=====登录返回:" + repoResult.getResult());
            System.out.println("<=====登录返回:" + repoResult.getResponseStatus().getErrorCode());
            System.out.println("<=====登录返回:" + repoResult.getResponseStatus().getSuccessEntitys());
            System.out.println("<=====登录返回:" + repoResult.getResponseStatus().getErrors());
            return isSuccess;
        } catch (Exception var10) {
            var10.printStackTrace();
            return false;
        }
    }

    public Boolean login(String dbId, String userName, String appId, String appSec, int lcid) throws Exception {
        try {
//            IdentifyInfo iden = new IdentifyInfo();
//            iden.setUserName(userName);
//            iden.setAppId(appId);
//            iden.setAppSecret(appSec);
//            iden.setdCID(dbId);
//            iden.setlCID(lcid);
//            iden.setServerUrl(_serverUrl);
            IdentifyInfo iden = new IdentifyInfo();
            iden.setUserName(userName);
            iden.setAppId("267026_TedP2+IJznBfWUXEX4SB78+L4J07QsKo");
            iden.setAppSecret("4db4e81eeb65ada35ff203b181552de87c2c1c99");
            iden.setdCID(dbId);
            iden.setlCID(lcid);
            iden.setServerUrl(_serverUrl);
            api = new K3CloudApi(iden);
            RepoResult repoResult = api.CheckAuthInfo();
            RepoStatus responseStatus = repoResult.getResponseStatus();
            boolean isSuccess = responseStatus.isIsSuccess();
            return isSuccess;
        } catch (Exception var10) {
            var10.printStackTrace();
            return false;
        }
    }
}
