package org.jeecg.modules.iost.ims.client;

import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;

public class SerializerProxy {
    public SerializerProxy() {
    }

    public Object deserialize(String content, Class<?> type) {
        if (content != null && content.length() != 0) {
            return "java.lang.string".equalsIgnoreCase(type.getName()) ? content : this.toDeserialize(content, type);
        } else if (!type.isPrimitive()) {
            return type;
        } else {
            return "java.lang.String".equalsIgnoreCase(type.getName()) ? content : null;
        }
    }

    public Object toDeserialize(String content, Class<?> type) {
        ObjectMapper mapper = new ObjectMapper();

        try {
            return mapper.readValue(content, type);
        } catch (IOException var5) {
            var5.printStackTrace();
            return null;
        }
    }
}