package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsBsMtrl;
import org.jeecg.modules.iost.ims.service.IImsBsMtrlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

/**
 * @Description: 物料基础信息
 * @Author: jeecg-boot
 * @Date: 2021-12-13
 * @Version: V1.0
 */
@Api(tags = "物料基础信息")
@RestController
@RequestMapping("/imsBsMtrl")
@Slf4j
public class ImsBsMtrlController extends JeecgController<ImsBsMtrl, IImsBsMtrlService> {
    @Autowired
    private IImsBsMtrlService imsBsMtrlService;

    /**
     * 分页列表查询
     *
     * @param imsBsMtrl
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "物料基础信息-分页列表查询")
    @ApiOperation(value = "物料基础信息-分页列表查询", notes = "物料基础信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsBsMtrl imsBsMtrl,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req, String date) {
        QueryWrapper<ImsBsMtrl> queryWrapper = QueryGenerator.initQueryWrapper(imsBsMtrl, req.getParameterMap());
        Page<ImsBsMtrl> page = new Page<ImsBsMtrl>(pageNo, pageSize);
        if (!"null".equals(date)) {
            SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
            Date parse = null;
            try {
                parse = sdf1.parse(date);
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //根据查询日期拿到明天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(parse);
            calendar.add(Calendar.DATE, 1);
            String parse1 = sdf1.format(calendar.getTime());
            queryWrapper.gt("create_time", parse);
            queryWrapper.lt("create_time", parse1);
        }
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("create_time", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("mtrl_code", codeString);
        }
        queryWrapper.orderByDesc("create_time");
        IPage<ImsBsMtrl> pageList = imsBsMtrlService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsBsMtrl
     * @return
     */
    @AutoLog(value = "物料基础信息-添加")
    @ApiOperation(value = "物料基础信息-添加", notes = "物料基础信息-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsBsMtrl imsBsMtrl) {
        imsBsMtrlService.save(imsBsMtrl);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsBsMtrl
     * @return
     */
    @AutoLog(value = "物料基础信息-编辑")
    @ApiOperation(value = "物料基础信息-编辑", notes = "物料基础信息-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsBsMtrl imsBsMtrl) {
        imsBsMtrlService.updateById(imsBsMtrl);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "物料基础信息-通过id删除")
    @ApiOperation(value = "物料基础信息-通过id删除", notes = "物料基础信息-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsBsMtrlService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "物料基础信息-批量删除")
    @ApiOperation(value = "物料基础信息-批量删除", notes = "物料基础信息-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsBsMtrlService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "物料基础信息-通过id查询")
    @ApiOperation(value = "物料基础信息-通过id查询", notes = "物料基础信息-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsBsMtrl imsBsMtrl = imsBsMtrlService.getById(id);
        if (imsBsMtrl == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsBsMtrl);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsBsMtrl
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsBsMtrl imsBsMtrl) {
        return super.exportXls(request, imsBsMtrl, ImsBsMtrl.class, "物料基础信息");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsBsMtrl.class);
    }

    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "物料基础信息-同步")
    @ApiOperation(value = "物料基础信息-同步", notes = "物料基础信息-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag = imsBsMtrlService.synchronization(id, "BD_MATERIAL", sysUser);
        if (flag) {
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
