package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsCommonPush;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsPushConstants;
import org.jeecg.modules.iost.ims.service.IImsCommonPushService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@RestController
public class ImsCommonPushController {

    @Autowired
    private IImsCommonPushService iImsCommonPushService;

    @Autowired
    private ImsPushConstants imsPushConstants;


    @GetMapping("/common/push/list")
    @AutoLog(value = "通用下推配置-列表")
    @ApiOperation(value = "通用下推配置-列表", notes = "通用下推配置-列表")
    public Result<?> commonSynList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        QueryWrapper<ImsCommonPush> queryWrapper = new QueryWrapper<>();
        Page<ImsCommonPush> page = new Page<>(pageNo, pageSize);
        IPage<ImsCommonPush> recordsList = iImsCommonPushService.page(page, queryWrapper);
        return Result.OK(recordsList);
    }

    @PostMapping("/common/push/add")
    @AutoLog(value = "通用下推配置-录入")
    @ApiOperation(value = "通用下推-录入", notes = "通用下推-录入")
    public Result<?> commonSynAdd(@RequestBody ImsCommonPush imsCommonPush) {
        if (!CollectionUtils.isEmpty(imsCommonPush.getTempList())) {
            imsCommonPush.setDetail(JsonUtil.toString(imsCommonPush.getTempList()));
        }
        iImsCommonPushService.save(imsCommonPush);
        imsPushConstants.set(imsCommonPush.getDocType());
        return Result.OK("录入成功");
    }

    @PutMapping("/common/push/update")
    @AutoLog(value = "通用下推配置-编辑")
    @ApiOperation(value = "通用下推-编辑", notes = "通用下推-编辑")
    public Result<?> commonSynUpdate(@RequestBody ImsCommonPush imsCommonPush) {
        if (!CollectionUtils.isEmpty(imsCommonPush.getTempList())) {
            imsCommonPush.setDetail(JsonUtil.toString(imsCommonPush.getTempList()));
        }
        iImsCommonPushService.updateById(imsCommonPush);
        imsPushConstants.set(imsCommonPush.getDocType());
        return Result.OK("编辑成功");
    }

    @DeleteMapping("/common/push/delete")
    @AutoLog(value = "通用下推配置-删除")
    @ApiOperation(value = "通用下推-删除", notes = "通用下推-删除")
    public Result<?> commonSynDelete(@ModelAttribute ImsCommonPush imsCommonPush) {
        iImsCommonPushService.removeById(imsCommonPush.getId());
        imsPushConstants.del(imsCommonPush.getDocType());
        return Result.OK("删除成功");
    }


}
