package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.entity.ImsCommonSyn;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.service.IImsCommonSynService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@RestController
public class ImsCommonSynController {

    @Autowired
    private IImsCommonSynService iImsCommonSynService;

    @Autowired
    private ImsSynConstants imsSynConstants;


    @GetMapping("/common/syn/list")
    @AutoLog(value = "通用同步配置-列表")
    @ApiOperation(value = "通用同步配置-列表", notes = "通用同步配置-列表")
    public Result<?> commonSynList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        QueryWrapper<ImsCommonSyn> queryWrapper = new QueryWrapper<>();
        Page<ImsCommonSyn> page = new Page<>(pageNo, pageSize);
        IPage<ImsCommonSyn> recordsList = iImsCommonSynService.page(page, queryWrapper);
        return Result.OK(recordsList);
    }

    @PostMapping("/common/syn/add")
    @AutoLog(value = "通用同步配置-录入")
    @ApiOperation(value = "通用同步配置-录入", notes = "通用同步配置-录入")
    public Result<?> commonSynAdd(@RequestBody ImsCommonSyn imsCommonSyn) {
        if (!CollectionUtils.isEmpty(imsCommonSyn.getTempList())) {
            imsCommonSyn.setDetail(JsonUtil.toString(imsCommonSyn.getTempList()));
        }
        iImsCommonSynService.save(imsCommonSyn);
        imsSynConstants.set(imsCommonSyn.getFormId());
        return Result.OK("录入成功");
    }

    @PutMapping("/common/syn/update")
    @AutoLog(value = "通用同步配置-编辑")
    @ApiOperation(value = "通用同步配置-编辑", notes = "通用同步配置-编辑")
    public Result<?> commonSynUpdate(@RequestBody ImsCommonSyn imsCommonSyn) {
        if (!CollectionUtils.isEmpty(imsCommonSyn.getTempList())) {
            imsCommonSyn.setDetail(JsonUtil.toString(imsCommonSyn.getTempList()));
        }
        iImsCommonSynService.updateById(imsCommonSyn);
        imsSynConstants.set(imsCommonSyn.getFormId());
        return Result.OK("编辑成功");
    }

    @DeleteMapping("/common/syn/delete")
    @AutoLog(value = "通用同步配置-删除")
    @ApiOperation(value = "通用同步配置-删除", notes = "通用同步配置-删除")
    public Result<?> commonSynDelete(@ModelAttribute ImsCommonSyn imsCommonSyn) {
        iImsCommonSynService.removeById(imsCommonSyn.getId());
        imsSynConstants.del(imsCommonSyn.getFormId());
        return Result.OK("删除成功");
    }


}
