package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsCustomerOtherReceiveConfirm;
import org.jeecg.modules.iost.ims.service.IImsCustomerOtherReceiveConfirmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

 /**
 * @Description: 客退品其他收料确认
 * @Author: jeecg-boot
 * @Date:   2021-12-22
 * @Version: V1.0
 */
@Api(tags="客退品其他收料确认")
@RestController
@RequestMapping("/dadss/imsCustomerOtherReceiveConfirm")
@Slf4j
public class ImsCustomerOtherReceiveConfirmController extends JeecgController<ImsCustomerOtherReceiveConfirm, IImsCustomerOtherReceiveConfirmService> {
	@Autowired
	private IImsCustomerOtherReceiveConfirmService imsCustomerOtherReceiveConfirmService;
	
	/**
	 * 分页列表查询
	 *
	 * @param imsCustomerOtherReceiveConfirm
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "客退品其他收料确认-分页列表查询")
	@ApiOperation(value="客退品其他收料确认-分页列表查询", notes="客退品其他收料确认-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(ImsCustomerOtherReceiveConfirm imsCustomerOtherReceiveConfirm,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
								   HttpServletRequest req) {
		QueryWrapper<ImsCustomerOtherReceiveConfirm> queryWrapper = QueryGenerator.initQueryWrapper(imsCustomerOtherReceiveConfirm, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
		Page<ImsCustomerOtherReceiveConfirm> page = new Page<ImsCustomerOtherReceiveConfirm>(pageNo, pageSize);
		IPage<ImsCustomerOtherReceiveConfirm> pageList = imsCustomerOtherReceiveConfirmService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param imsCustomerOtherReceiveConfirm
	 * @return
	 */
	@AutoLog(value = "客退品其他收料确认-添加")
	@ApiOperation(value="客退品其他收料确认-添加", notes="客退品其他收料确认-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody ImsCustomerOtherReceiveConfirm imsCustomerOtherReceiveConfirm) {
		imsCustomerOtherReceiveConfirmService.save(imsCustomerOtherReceiveConfirm);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param imsCustomerOtherReceiveConfirm
	 * @return
	 */
	@AutoLog(value = "客退品其他收料确认-编辑")
	@ApiOperation(value="客退品其他收料确认-编辑", notes="客退品其他收料确认-编辑")
	@PutMapping(value = "/edit")
	public Result<?> edit(@RequestBody ImsCustomerOtherReceiveConfirm imsCustomerOtherReceiveConfirm) {
		imsCustomerOtherReceiveConfirmService.updateById(imsCustomerOtherReceiveConfirm);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "客退品其他收料确认-通过id删除")
	@ApiOperation(value="客退品其他收料确认-通过id删除", notes="客退品其他收料确认-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		imsCustomerOtherReceiveConfirmService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "客退品其他收料确认-批量删除")
	@ApiOperation(value="客退品其他收料确认-批量删除", notes="客退品其他收料确认-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.imsCustomerOtherReceiveConfirmService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "客退品其他收料确认-通过id查询")
	@ApiOperation(value="客退品其他收料确认-通过id查询", notes="客退品其他收料确认-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		ImsCustomerOtherReceiveConfirm imsCustomerOtherReceiveConfirm = imsCustomerOtherReceiveConfirmService.getById(id);
		if(imsCustomerOtherReceiveConfirm==null) {
			return Result.error("未找到对应数据");
		}
		return Result.OK(imsCustomerOtherReceiveConfirm);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param imsCustomerOtherReceiveConfirm
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsCustomerOtherReceiveConfirm imsCustomerOtherReceiveConfirm) {
        return super.exportXls(request, imsCustomerOtherReceiveConfirm, ImsCustomerOtherReceiveConfirm.class, "客退品其他收料确认");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsCustomerOtherReceiveConfirm.class);
    }

}
