package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsCustomerSupplyConfirm;
import org.jeecg.modules.iost.ims.service.ImsCustomerSupplyConfirmService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * @Description: ImsCustomerSupplyConfirm  客供料收料确认
 * @Author: jeecg-boot
 * @Date: 2021-12-03
 * @Version: V1.0
 */
@Api(tags = "客供料收料确认")
@RestController
@RequestMapping("/ims-customer-supply-confirm")
public class ImsCustomerSupplyConfirmController {
    @Autowired
    private ImsCustomerSupplyConfirmService ImsCustomerSupplyConfirmService;

    @AutoLog(value = "分页列表查询")
    @ApiOperation(value = "ims_customer_supply-分页列表查询", notes = "ims_customer_supply-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsCustomerSupplyConfirm imsCustomerSupplyConfirm,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsCustomerSupplyConfirm> queryWrapper = QueryGenerator.initQueryWrapper(imsCustomerSupplyConfirm, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        Page<ImsCustomerSupplyConfirm> page = new Page<ImsCustomerSupplyConfirm>(pageNo, pageSize);
        IPage<ImsCustomerSupplyConfirm> pageList = ImsCustomerSupplyConfirmService.page(page, queryWrapper);
        return Result.OK(pageList);
    }
}
