package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsInventoryLoss;
import org.jeecg.modules.iost.ims.service.IImsInventoryLossService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 盘亏
 * @Author: ly
 * @Date: 2021-12-09
 * @Version: V1.0
 */
@Api(tags = "盘亏")
@RestController
@RequestMapping("/ims/imsInventoryLoss")
@Slf4j
public class ImsInventoryLossController extends JeecgController<ImsInventoryLoss, IImsInventoryLossService> {
    @Autowired
    private IImsInventoryLossService imsInventoryLossService;

    /**
     * 分页列表查询
     *
     * @param imsInventoryLoss
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "盘亏-分页列表查询")
    @ApiOperation(value = "盘亏-分页列表查询", notes = "盘亏-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsInventoryLoss imsInventoryLoss,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsInventoryLoss> queryWrapper = QueryGenerator.initQueryWrapper(imsInventoryLoss, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        queryWrapper.orderByDesc("trx_date");
        Page<ImsInventoryLoss> page = new Page<ImsInventoryLoss>(pageNo, pageSize);
        IPage<ImsInventoryLoss> pageList = imsInventoryLossService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsInventoryLoss
     * @return
     */
    @AutoLog(value = "盘亏-添加")
    @ApiOperation(value = "盘亏-添加", notes = "盘亏-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsInventoryLoss imsInventoryLoss) {
        imsInventoryLossService.save(imsInventoryLoss);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsInventoryLoss
     * @return
     */
    @AutoLog(value = "盘亏-编辑")
    @ApiOperation(value = "盘亏-编辑", notes = "盘亏-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsInventoryLoss imsInventoryLoss) {
        imsInventoryLossService.updateById(imsInventoryLoss);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "盘亏-通过id删除")
    @ApiOperation(value = "盘亏-通过id删除", notes = "盘亏-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsInventoryLossService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "盘亏-批量删除")
    @ApiOperation(value = "盘亏-批量删除", notes = "盘亏-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsInventoryLossService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "盘亏-通过id查询")
    @ApiOperation(value = "盘亏-通过id查询", notes = "盘亏-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsInventoryLoss imsInventoryLoss = imsInventoryLossService.getById(id);
        if (imsInventoryLoss == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsInventoryLoss);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsInventoryLoss
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsInventoryLoss imsInventoryLoss) {
        return super.exportXls(request, imsInventoryLoss, ImsInventoryLoss.class, "盘亏");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsInventoryLoss.class);
    }

}
