package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsMaintainPicking;
import org.jeecg.modules.iost.ims.service.IImsMaintainPickingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 维修领料
 * @Author: jeecg-boot
 * @Date: 2022-01-07
 * @Version: V1.0
 */
@Api(tags = "维修领料")
@RestController
@RequestMapping("/org.jeecg.modules.iost.ims.entity/imsMaintainPicking")
@Slf4j
public class ImsMaintainPickingController extends JeecgController<ImsMaintainPicking, IImsMaintainPickingService> {
    @Autowired
    private IImsMaintainPickingService imsMaintainPickingService;

    /**
     * 分页列表查询
     *
     * @param imsMaintainPicking
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "维修领料-分页列表查询")
    @ApiOperation(value = "维修领料-分页列表查询", notes = "维修领料-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsMaintainPicking imsMaintainPicking,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsMaintainPicking> queryWrapper = QueryGenerator.initQueryWrapper(imsMaintainPicking, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        queryWrapper.orderByDesc("trx_date");
        Page<ImsMaintainPicking> page = new Page<ImsMaintainPicking>(pageNo, pageSize);
        IPage<ImsMaintainPicking> pageList = imsMaintainPickingService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsMaintainPicking
     * @return
     */
    @AutoLog(value = "维修领料-添加")
    @ApiOperation(value = "维修领料-添加", notes = "维修领料-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsMaintainPicking imsMaintainPicking) {
        imsMaintainPickingService.save(imsMaintainPicking);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsMaintainPicking
     * @return
     */
    @AutoLog(value = "维修领料-编辑")
    @ApiOperation(value = "维修领料-编辑", notes = "维修领料-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsMaintainPicking imsMaintainPicking) {
        imsMaintainPickingService.updateById(imsMaintainPicking);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "维修领料-通过id删除")
    @ApiOperation(value = "维修领料-通过id删除", notes = "维修领料-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsMaintainPickingService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "维修领料-批量删除")
    @ApiOperation(value = "维修领料-批量删除", notes = "维修领料-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsMaintainPickingService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "维修领料-通过id查询")
    @ApiOperation(value = "维修领料-通过id查询", notes = "维修领料-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsMaintainPicking imsMaintainPicking = imsMaintainPickingService.getById(id);
        if (imsMaintainPicking == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsMaintainPicking);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsMaintainPicking
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsMaintainPicking imsMaintainPicking) {
        return super.exportXls(request, imsMaintainPicking, ImsMaintainPicking.class, "维修领料");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsMaintainPicking.class);
    }

}
