package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsProduceOrderClose;
import org.jeecg.modules.iost.ims.service.IImsProduceOrderCloseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 工单关单
 * @Author: jeecg-boot
 * @Date: 2022-01-07
 * @Version: V1.0
 */
@Api(tags = "工单关单")
@RestController
@RequestMapping("/org.jeecg.modules.iost.ims.entity/imsProduceOrderClose")
@Slf4j
public class ImsProduceOrderCloseController extends JeecgController<ImsProduceOrderClose, IImsProduceOrderCloseService> {
    @Autowired
    private IImsProduceOrderCloseService imsProduceOrderCloseService;

    /**
     * 分页列表查询
     *
     * @param imsProduceOrderClose
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "工单关单-分页列表查询")
    @ApiOperation(value = "工单关单-分页列表查询", notes = "工单关单-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsProduceOrderClose imsProduceOrderClose,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsProduceOrderClose> queryWrapper = QueryGenerator.initQueryWrapper(imsProduceOrderClose, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbill_no", codeString);
        }
        queryWrapper.orderByDesc("trx_date");
        Page<ImsProduceOrderClose> page = new Page<ImsProduceOrderClose>(pageNo, pageSize);
        IPage<ImsProduceOrderClose> pageList = imsProduceOrderCloseService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsProduceOrderClose
     * @return
     */
    @AutoLog(value = "工单关单-添加")
    @ApiOperation(value = "工单关单-添加", notes = "工单关单-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsProduceOrderClose imsProduceOrderClose) {
        imsProduceOrderCloseService.save(imsProduceOrderClose);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsProduceOrderClose
     * @return
     */
    @AutoLog(value = "工单关单-编辑")
    @ApiOperation(value = "工单关单-编辑", notes = "工单关单-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsProduceOrderClose imsProduceOrderClose) {
        imsProduceOrderCloseService.updateById(imsProduceOrderClose);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "工单关单-通过id删除")
    @ApiOperation(value = "工单关单-通过id删除", notes = "工单关单-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsProduceOrderCloseService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "工单关单-批量删除")
    @ApiOperation(value = "工单关单-批量删除", notes = "工单关单-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsProduceOrderCloseService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "工单关单-通过id查询")
    @ApiOperation(value = "工单关单-通过id查询", notes = "工单关单-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsProduceOrderClose imsProduceOrderClose = imsProduceOrderCloseService.getById(id);
        if (imsProduceOrderClose == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsProduceOrderClose);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsProduceOrderClose
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsProduceOrderClose imsProduceOrderClose) {
        return super.exportXls(request, imsProduceOrderClose, ImsProduceOrderClose.class, "工单关单");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsProduceOrderClose.class);
    }

}
