package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.iost.ims.entity.ImsProductOut;
import org.jeecg.modules.iost.ims.service.IImsProductOutService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * @Description: 产品出货
 * @Author: jeecg-boot
 * @Date: 2021-12-30
 * @Version: V1.0
 */
@Api(tags = "产品出货")
@RestController
@RequestMapping("/imsProductOut")
@Slf4j
public class ImsProductOutController extends JeecgController<ImsProductOut, IImsProductOutService> {
    @Autowired
    private IImsProductOutService imsProductOutService;

    /**
     * 分页列表查询
     *
     * @param imsProductOut
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "产品出货-分页列表查询")
    @ApiOperation(value = "产品出货-分页列表查询", notes = "产品出货-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsProductOut imsProductOut,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsProductOut> queryWrapper = QueryGenerator.initQueryWrapper(imsProductOut, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("trx_date", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("fbillno", codeString);
        }
        queryWrapper.orderByDesc("trx_date");
        Page<ImsProductOut> page = new Page<ImsProductOut>(pageNo, pageSize);
        IPage<ImsProductOut> pageList = imsProductOutService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsProductOut
     * @return
     */
    @AutoLog(value = "产品出货-添加")
    @ApiOperation(value = "产品出货-添加", notes = "产品出货-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsProductOut imsProductOut) {
        imsProductOutService.save(imsProductOut);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsProductOut
     * @return
     */
    @AutoLog(value = "产品出货-编辑")
    @ApiOperation(value = "产品出货-编辑", notes = "产品出货-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsProductOut imsProductOut) {
        imsProductOutService.updateById(imsProductOut);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "产品出货-通过id删除")
    @ApiOperation(value = "产品出货-通过id删除", notes = "产品出货-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsProductOutService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "产品出货-批量删除")
    @ApiOperation(value = "产品出货-批量删除", notes = "产品出货-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsProductOutService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "产品出货-通过id查询")
    @ApiOperation(value = "产品出货-通过id查询", notes = "产品出货-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsProductOut imsProductOut = imsProductOutService.getById(id);
        if (imsProductOut == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsProductOut);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsProductOut
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsProductOut imsProductOut) {
        return super.exportXls(request, imsProductOut, ImsProductOut.class, "产品出货");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsProductOut.class);
    }

}
