package org.jeecg.modules.iost.ims.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.entity.ImsSalOutStock;
import org.jeecg.modules.iost.ims.entity.ImsSalOutStockReceive;
import org.jeecg.modules.iost.ims.kingdeeapi.ImsSynConstants;
import org.jeecg.modules.iost.ims.service.IImsSalOutStockService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 销售出库单
 */


@Api(tags = "销售出库单")
@RestController
@RequestMapping("/imsSalOutStock")
@Slf4j
public class ImsSalOutStockController extends JeecgController<ImsSalOutStock, IImsSalOutStockService> {
    @Autowired
    CategoryDao categoryDao;

    @Autowired
    IImsSalOutStockService imsSalOutStockService;

    @Autowired
    private ImsSynConstants imsSynConstants;


    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "销售出库单-同步")
    @ApiOperation(value = "销售出库单-同步", notes = "销售出库单-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag = imsSalOutStockService.synchronization(id, "SAL_DELIVERYNOTICE", sysUser);
        if (flag) {
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }


    /**
     * 返回是否可以撤销销售出库单
     * @param imsSalOutStockReceive
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "销售出库单-撤销")
    @ApiOperation(value = "销售出库单-撤销", notes = "销售出库单-撤销")
    @PostMapping(value = "/cancelAssign")
    public Result<?> cancelAssign(@RequestBody ImsSalOutStockReceive imsSalOutStockReceive) throws Exception {
        //先调用IMS的删除销售出库单接口
        System.out.println(imsSalOutStockReceive.getNumbers());
        Map<String, Object> map = imsSalOutStockService.cancelAssign("SAL_OUTSTOCK", imsSalOutStockReceive.getNumbers());
        if ((Boolean) map.get("success")){
            return Result.OKMSG("可撤销",true);
        }
        String errorMsg = "不可撤销,错误信息为"+map.get("msg");
        return Result.fail(errorMsg,false,"500");
    }
}
