package org.jeecg.modules.iost.ims.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.iost.ims.entity.ImsSmPo;
import org.jeecg.modules.iost.ims.service.IImsSmPoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.Arrays;

/**
 * @Description: 采购订单信息
 * @Author: jeecg-boot
 * @Date: 2021-12-24
 * @Version: V1.0
 */
@Api(tags = "采购订单信息")
@RestController
@RequestMapping("/imsSmPo")
@Slf4j
public class ImsSmPoController extends JeecgController<ImsSmPo, IImsSmPoService> {
    @Autowired
    private IImsSmPoService imsSmPoService;

    /**
     * 分页列表查询
     *
     * @param imsSmPo
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "采购订单信息-分页列表查询")
    @ApiOperation(value = "采购订单信息-分页列表查询", notes = "采购订单信息-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(ImsSmPo imsSmPo,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   String dateString, String codeString, String queueId,
                                   HttpServletRequest req) {
        QueryWrapper<ImsSmPo> queryWrapper = QueryGenerator.initQueryWrapper(imsSmPo, req.getParameterMap());
        if (StringUtils.isNotBlank(dateString)) {
            String[] split = dateString.split(",");
            queryWrapper.between("create_time", split[0], split[1]);
        }
        if (StringUtils.isNotBlank(codeString)) {
            queryWrapper.eq("po_code", codeString);
        }
        queryWrapper.orderByDesc("create_time");
        Page<ImsSmPo> page = new Page<ImsSmPo>(pageNo, pageSize);
        IPage<ImsSmPo> pageList = imsSmPoService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param imsSmPo
     * @return
     */
    @AutoLog(value = "采购订单信息-添加")
    @ApiOperation(value = "采购订单信息-添加", notes = "采购订单信息-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody ImsSmPo imsSmPo) {
        imsSmPoService.save(imsSmPo);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param imsSmPo
     * @return
     */
    @AutoLog(value = "采购订单信息-编辑")
    @ApiOperation(value = "采购订单信息-编辑", notes = "采购订单信息-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody ImsSmPo imsSmPo) {
        imsSmPoService.updateById(imsSmPo);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "采购订单信息-通过id删除")
    @ApiOperation(value = "采购订单信息-通过id删除", notes = "采购订单信息-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        imsSmPoService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "采购订单信息-批量删除")
    @ApiOperation(value = "采购订单信息-批量删除", notes = "采购订单信息-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.imsSmPoService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @AutoLog(value = "采购订单信息-通过id查询")
    @ApiOperation(value = "采购订单信息-通过id查询", notes = "采购订单信息-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        ImsSmPo imsSmPo = imsSmPoService.getById(id);
        if (imsSmPo == null) {
            return Result.error("未找到对应数据");
        }
        return Result.OK(imsSmPo);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param imsSmPo
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ImsSmPo imsSmPo) {
        return super.exportXls(request, imsSmPo, ImsSmPo.class, "采购订单信息");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ImsSmPo.class);
    }

    /**
     * 同步
     *
     * @return
     * @throws ParseException
     */
    @AutoLog(value = "调拨单信息-同步")
    @ApiOperation(value = "调拨单信息-同步", notes = "调拨单信息-同步")
    @PostMapping(value = "/synchronization")
    public Result<?> synchronization(@RequestBody String id) throws ParseException {
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        Boolean flag = imsSmPoService.synchronization(id, "PUR_PurchaseOrder", sysUser);
        if (flag) {
            return Result.OK("同步成功");
        }
        return Result.error("同步失败");
    }

}
