package org.jeecg.modules.iost.ims.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.api.client.util.IOUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.exception.ConnectConstant.KingDeeConstant;
import org.jeecg.common.exception.KingdeeConnectException;
import org.jeecg.common.util.RedisLock;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.aspect.annotation.NotCommitRedisLock;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.ExternalInterface.IMSApi;
import org.jeecg.modules.iost.ims.Util.ImsLogUtil;
import org.jeecg.modules.iost.ims.Util.JsonUtil;
import org.jeecg.modules.iost.ims.client.KingdeeK3CloudApiClient;
import org.jeecg.modules.iost.ims.entity.ImsInitConnectParm;
import org.jeecg.modules.iost.ims.entity.Vo.ConnectParmVo;
import org.jeecg.modules.iost.ims.entity.Vo.ImsRequestVo;
import org.jeecg.modules.iost.ims.entity.Vo.imsConnectParm;
import org.jeecg.modules.iost.ims.entity.Vo.kingdeeConnectParm;
import org.jeecg.modules.iost.ims.service.*;
import org.jeecg.modules.iost.ims.vo.ImsRequest;
import org.jeecg.modules.online.cgform.b.d;
import org.jeecg.modules.online.cgform.service.IOnlCgformHeadService;
import org.jeecg.modules.quartz.entity.QuartzJob;
import org.jeecg.modules.quartz.service.IQuartzJobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 第三方通用接口
 * @Author: jeecg-boot
 * @Date: 2021-12-02
 * @Version: V1.0
 */
@Api(tags = "第三方通用接口")
@RestController
@RequestMapping("/api")
@Slf4j
public class WebApi {

    @Autowired
    ThreadPoolTaskScheduler threadPoolTaskSched;
    @Autowired
    IImsInitConnectParmService iImsInitConnectParmService;
    @Autowired
    ImsPurchaseOrderConfirmService imsPurchaseOrderConfirmService;
    @Autowired
    ImsPurchaseOrderService imsPurchaseOrderService;
    @Autowired
    ImsCustomerSupplyConfirmService imsCustomerSupplyConfirmService;
    @Autowired
    ImsNoPurchaseOrderConfirmService imsNoPurchaseOrderConfirmService;
    @Autowired
    ImsAsnReceiveService imsAsnReceiveService;
    @Autowired
    IImsProcessScrapReceiptService iImsProcessScrapReceiptService;
    @Autowired
    IImsInventorySurplusService imsInventorySurplusService;
    @Autowired
    IImsInventoryLossService iImsInventoryLossService;
    @Autowired
    ImsAsnReceiveConfirmService imsAsnReceiveConfirmService;
    @Autowired
    IImsMiscellaneousIssueService iImsMiscellaneousIssueService;
    @Autowired
    IImsSupplierReturnsService iImsSupplierReturnsService;
    @Autowired
    IImsReturnMaterialDefectiveProductsService imsReturnMaterialDefectiveProductsService;
    @Autowired
    ImsOtherReceiveConfirmService imsOtherReceiveConfirmService;
    @Autowired
    ImsCustomerNoPurchaseOrderConfirmService imsCustomerNoPurchaseOrderConfirmService;
    @Autowired
    IImsOutOfWarehouseOverReceiveService iImsOutOfWarehouseOverReceiveService;
    @Autowired
    ImsCustomerPurchaseOrderConfirmService imsCustomerPurchaseOrderConfirmService;
    @Autowired
    ImsCustomerAsnReceiveConfirmService imsCustomerAsnReceiveConfirmService;
    @Autowired
    IImsCustomerOtherReceiveConfirmService imsCustomerOtherReceiveConfirmervice;
    @Autowired
    IImsSpareReceiveConfirmService iImsSpareReceiveConfirmService;
    @Autowired
    IImsScrapReceiveConfirmService iImsScrapReceiveConfirmService;
    @Autowired
    IImsRejectionConfirmService iImsRejectionConfirmService;
    @Autowired
    IImsDefectiveReceiveConfirmService iImsDefectiveReceiveConfirmService;
    @Autowired
    IImsDefectiveOutstockService iImsDefectiveOutstockService;
    @Autowired
    IImsReturnMaterialService iImsReturnMaterialService;
    @Autowired
    IImsProduceCancelService produceCancelService;
    @Autowired
    IImsProduceReceivingService produceReceivingService;
    @Autowired
    IImsProductOutService productOutService;
    @Autowired
    IImsNondefectiveFlittingService iImsNondefectiveFlittingService;
    @Autowired
    IImsDefectiveFlittingService iImsDefectiveFlittingService;
    @Autowired
    IImsOutstockOrderOutstockService iImsOutstockOrderOutstockService;
    @Autowired
    IImsProductionReceiveConfirmService iImsProductionReceiveConfirmService;
    @Autowired
    IImsMaintainPickingService iImsMaintainPickingService;
    @Autowired
    IImsProduceOrderCloseService iImsProduceOrderCloseService;
    @Autowired
    IImsProduceOrderReadyService iImsProduceOrderReadyService;
    @Autowired
    IImsDeductionFormService deductionFormService;
    @Autowired
    IImsPurchaseWarehousingService iImsPurchaseWarehousingService;
    @Autowired
    IImsPurchaseReturnService iImsPurchaseReturnService;
    @Autowired
    IImsCommonPushService iImsCommonPushService;
    @Autowired
    IImsPayableService iImsPayableService;
    @Autowired
    IImmediateInventoryService immediateInventoryService;
    @Autowired
    IBillOfMaterialServer billOfMaterialServer;
    @Autowired
    IImsSalOutStockService imsSalOutStockService;

    /**
     * 传入数据到金蝶云
     *
     * @return
     * @throws ParseException
     */
    @Autowired
    RedisLock redisLock;

    @AutoLog(value = "IMS通用接口")
    @ApiOperation(value = "IMS通用接口", notes = "IMS通用接口")
    @PostMapping(value = "/GetData")
    public Result<?> GetData(@RequestBody ImsRequest request) {
        if (CollectionUtils.isEmpty(request.getData())) {
            return Result.fail("操作失败", "data不能为空", request.getDocType());
        }
        Map<String, Object> data = new HashMap<>();

        if ("STK_InStock".equals(request.getDocType())) {
            //采购入库单
            data = iImsPurchaseWarehousingService.getData(request.getData());
        } else if ("PUR_MRB".equals(request.getDocType())) {
            //采购退货单
            data = iImsPurchaseReturnService.getData(request.getData());
        } else if ("STK_Inventory".equals(request.getDocType())) {
            //即时库存
            data = immediateInventoryService.getData(request.getData());
        } else {
            return Result.fail("操作失败", request.getDocType() + "不存在!", request.getDocType());
        }

        if (data.containsKey("false")) {
            return Result.fail("操作失败", data.get("false"), request.getDocType());
        }
        return Result.OK(data.get("true"), request.getDocType());
    }

    @AutoLog(value = "IMS通用修改接口")
    @ApiOperation(value = "IMS通用修改接口", notes = "IMS通用修改接口")
    @PostMapping(value = "/updateData")
    public Result<?> updateData(@RequestBody ImsRequest request) {
        if (CollectionUtils.isEmpty(request.getData())) {
            return Result.fail("操作失败", "data不能为空", request.getDocType());
        }
        Map<String, Object> data = new HashMap<>();

        if ("STK_InStock".equals(request.getDocType())) {
            //采购入库单
            new ImsLogUtil().ImsRequestLog(JsonUtil.toString(request.getData()), "采购入库单修改", "采购入库单修改", request.getDocType());
            data = iImsPurchaseWarehousingService.updateData(request.getData());
            iImsPayableService.updateDataBySource(request.getData());
        } else if ("PUR_MRB".equals(request.getDocType())) {
            //采购退货单
            new ImsLogUtil().ImsRequestLog(JsonUtil.toString(request.getData()), "采购退货单修改", "采购退货单修改", request.getDocType());
            data = iImsPurchaseReturnService.updateData(request.getData());
            iImsPayableService.updateDataBySource(request.getData());
        } else if ("Expenses_Payable".equals(request.getDocType())) {
            //费用应付单
            new ImsLogUtil().ImsRequestLog(JsonUtil.toString(request.getData()), "费用应付单修改", "费用应付单修改", request.getDocType());
            data = iImsPayableService.updateData(request.getData());
        } else {
            return Result.fail("操作失败", request.getDocType() + "不存在!", request.getDocType());
        }

        if (data.containsKey("false")) {
            return Result.fail("操作失败", data.get("false"), request.getDocType());
        }
        return Result.OK(data.get("true"), request.getDocType());
    }

    /**
     * 修改添加数据到金蝶云通用接口
     */
    @AutoLog(value = "第三方通用接口-updateThirdData")
    @ApiOperation(value = "第三方通用接口-updateThirdData", notes = "第三方通用接口-updateThirdData")
    @PostMapping(value = "/updateThirdData")
    @NotCommitRedisLock
    public Result<?> updateData(@RequestBody ImsRequestVo request) {
        long start = System.currentTimeMillis();
        log.info("下推开始时间: {}", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        String result = new String();
        //根据doctype调用不同的业务service
        if (request.getDocType().equals("BS0001")) {//采购订单收料
            result = imsPurchaseOrderService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0002")) { //采购订单收料确认
            result = imsPurchaseOrderConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0004")) { //客供料收料确认
            result = imsCustomerSupplyConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0006")) { //无采购订单收料确认
            result = imsNoPurchaseOrderConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0008")) { //ASN收料
            result = imsAsnReceiveService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0009")) {//ASN收料确认
            result = imsAsnReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0011")) {//其他收料确认
            result = imsOtherReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0013")) {//客退品采购订单收料确认
            result = imsCustomerPurchaseOrderConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0015")) {//客退品无采购订单收料确认
            result = imsCustomerNoPurchaseOrderConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0017")) {//客退品ASN收料确认
            result = imsCustomerAsnReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0019")) {//客退品其他收料确认
            result = imsCustomerOtherReceiveConfirmervice.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0022")) {//备品收料确认
            result = iImsSpareReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0023")) {//报废品收料确认
            //result = iImsScrapReceiveConfirmService.setData(request.getData(), request.getDocType());
            result = imsAsnReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0024")) {//不良品收料确认
            //result = iImsDefectiveReceiveConfirmService.setData(request.getData(), request.getDocType());
            result = imsAsnReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0025")) {//拒收确认
            result = iImsRejectionConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0026")) { //过程报废收料确认
            result = iImsProcessScrapReceiptService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0028")) {//盘盈
            result = imsInventorySurplusService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0029")) {//盘亏
            result = iImsInventoryLossService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0030")) {//良品调拨
            log.info("<=====BS0030开始");
            result = iImsNondefectiveFlittingService.setData(request.getData(), request.getDocType());
            log.info("<=====BS0030结束 " + result);
        } else if (request.getDocType().equals("BS0033")) {//不良品调拨
            result = iImsDefectiveFlittingService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0039")) {//出库单出库
            result = iImsOutstockOrderOutstockService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0043")) {//其他出库
            result = iImsMiscellaneousIssueService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0044")) {//不良品出库
            result = iImsDefectiveOutstockService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0045")) {//供应商退货
            result = iImsSupplierReturnsService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0050")) {//退料
            result = iImsReturnMaterialService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0051")) {//不良品退料
            result = imsReturnMaterialDefectiveProductsService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0055")) {//产品收料确认
            result = iImsProductionReceiveConfirmService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS0057")) {//工单关单
            result = iImsProduceOrderCloseService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("WMS0006")) {//出库超领
            result = iImsOutOfWarehouseOverReceiveService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("WMS0014")) {//备料取消
            result = produceCancelService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("WMS0012")) {//生产收料确认
            result = produceReceivingService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("WMS0003")) {//工单备料
            result = iImsProduceOrderReadyService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("WMS0005")) {//维修领料
            result = iImsMaintainPickingService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("WMS0007")) {//产品出货
            result = productOutService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("SUP_DEDUCTIONS")) {//扣款单
            result = deductionFormService.setData(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("SAL_OUTSTOCK_Audit")) {//销售出库单审核
            result = imsSalOutStockService.audit(request.getData(), request.getDocType());
        } else if (request.getDocType().equals("BS_MOMN_CHANGE")) {//生产用料清单
            //测试生产用料清单
            log.info("wss_调用了生产用料清单:" + String.valueOf(request.getData()));
            System.out.println("AAAA--调用了生产用料清单");
            result = billOfMaterialServer.setData(request.getData(), request.getDocType());
        } else {
            //通用下推
            result = iImsCommonPushService.setData(request.getData(), request.getDocType());
            if ("false".equals(result)) {
                return Result.fail("操作失败", request.getDocType() + "不存在!", request.getDocType());
            }
        }

        /*  }*/
        result = result.replace("\n", "");
        result = result.replace("\t", "");
        result = result.replace("\r", "");
        result = result.replace(" ", "");
        log.info("下推结束时间: {}", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
        log.info("下推总计用时: {}（毫秒）", System.currentTimeMillis() - start);
        return Result.OK(result, request.getDocType());

    }

    /*List<Map<String,Object>>转换Map<String,Object>*/
    public Map<String, Object> change(List<Map<String, Object>> data) {
        Map<String, Object> maps = new HashMap<>();
        for (Map<String, Object> datum : data) {
            for (String s : datum.keySet()) {
                maps.put(s, datum.get(s));
            }
        }
        return maps;
    }

    @Autowired
    ISynService synService;

    private Boolean IsOpenSyn = false;
    @Autowired
    private IQuartzJobService quartzJobService;

    /*启动自动同步功能*/
    @AutoLog(value = "第三方通用接口-启动同步功能")
    @ApiOperation(value = "第三方通用接口-启动同步功能", notes = "第三方通用接口-启动同步功能")
    @PostMapping(value = "/ManualSyn")
    public synchronized Result ManualSyn() {
        QuartzJob quartzJob = iQuartzJobService.getBaseMapper().selectById("999");
        boolean IsOpenSyn = !quartzJob.getStatus().equals(-1);
        Kingdeelogin();
        if (!IsOpenSyn) {
            QuartzJob job = null;
            job = quartzJobService.getOne(new LambdaQueryWrapper<QuartzJob>().eq(QuartzJob::getJobClassName, "org.jeecg.modules.quartz.job.imsSymJob"));
            quartzJobService.resumeJob(job);
            return Result.OK("启动自动同步成功");
        }
        Result r = new Result();
        r.setResult("已经启动过，请勿重复启动！");
        return r.error500("已经启动过，请勿重复启动！");
    }

    /*关闭自动同步的定时任务*/
    @PostMapping("/ManualSynStop")
    @AutoLog(value = "第三方通用接口-关闭自动同步的定时任务")
    @ApiOperation(value = "第三方通用接口-关闭自动同步的定时任务", notes = "第三方通用接口-关闭自动同步的定时任务")
    public Result ManualSynStop() {
        QuartzJob quartzJob = iQuartzJobService.getBaseMapper().selectById("999");
        boolean IsOpenSyn = !quartzJob.getStatus().equals(-1);
        Kingdeelogin();
        if (IsOpenSyn) {
            QuartzJob job = null;
            job = quartzJobService.getOne(new LambdaQueryWrapper<QuartzJob>().eq(QuartzJob::getJobClassName, "org.jeecg.modules.quartz.job.imsSymJob"));
            quartzJobService.pause(job);
            return Result.OK("关闭自动同步成功");
        } else {
            Result r = new Result();
            r.setResult("已经关闭，请勿重复关闭！");
            return r.error500("已经关闭，请勿重复关闭！");
        }

    }

    @Autowired
    CategoryDao categoryDao;
    @Autowired
    IMSApi imsApi;

    /*保存修改连接参数功能*/
    @PostMapping("/ManualSave")
    @AutoLog(value = "第三方通用接口-保存修改连接参数功能")
    @ApiOperation(value = "第三方通用接口-保存修改连接参数功能", notes = "第三方通用接口-保存修改连接参数功能")
    public synchronized Result ManualSave(@RequestBody ConnectParmVo connectParmVo) {
        QuartzJob quartzJob = iQuartzJobService.getBaseMapper().selectById("999");
        boolean IsOpenSyn = !quartzJob.getStatus().equals(-1);
        if (IsOpenSyn) {
            Result r = new Result();
            r.setResult("请先关闭同步再保存!");
            return r.error500("请先关闭同步再保存!");
        }
        ImsInitConnectParm imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        imsInitConnectParm.setK3CloudUrl(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        imsInitConnectParm.setDbid(connectParmVo.getKingdeeConnectParm().getDbId());
        imsInitConnectParm.setUid(connectParmVo.getKingdeeConnectParm().getUid());
        imsInitConnectParm.setPwd(connectParmVo.getKingdeeConnectParm().getPwd());
        imsInitConnectParm.setLang(connectParmVo.getKingdeeConnectParm().getLang());
        /*  imsInitConnectParm.setIsAutoSubmit(Integer.valueOf(connectParmVo.getKingdeeConnectParm().getIsAutoSubmit()));*/
        imsInitConnectParm.setUrl(connectParmVo.getImsConParm().getUrl());
        iImsInitConnectParmService.getBaseMapper().updateById(imsInitConnectParm);
        //改变单例categoryDao值
        categoryDao.setK3CloudURL(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        categoryDao.setDbId(connectParmVo.getKingdeeConnectParm().getDbId());
        categoryDao.setUid(connectParmVo.getKingdeeConnectParm().getUid());
        categoryDao.setPwd(connectParmVo.getKingdeeConnectParm().getPwd());
        categoryDao.setLang(connectParmVo.getKingdeeConnectParm().getLang());
        /*  categoryDao.setIsAutoSubmit(Integer.valueOf(connectParmVo.getKingdeeConnectParm().getIsAutoSubmit()));*/
        imsApi.setUrl(connectParmVo.getImsConParm().getUrl());
        KingdeeK3CloudApiClient client = categoryDao.getClient();
        client = new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        categoryDao.setClient2(new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL()));
        categoryDao.setClient3(new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL()));
        categoryDao.setClient(client);
        AfterKingdeelogin();
        return Result.OK("保存成功");
    }

    /*检验连接参数功能*/
    @PostMapping("/ManualCheck")
    @AutoLog(value = "第三方通用接口-检验连接参数功能")
    @ApiOperation(value = "第三方通用接口-检验连接参数功能", notes = "第三方通用接口-检验连接参数功能")
    public synchronized Result ManualCheck(@RequestBody ConnectParmVo connectParmVo) {
        Boolean result = false;
        KingdeeK3CloudApiClient client = new KingdeeK3CloudApiClient(connectParmVo.getKingdeeConnectParm().getK3CloudURL());
        String k3CloudURL = connectParmVo.getKingdeeConnectParm().getK3CloudURL();
        String dbId = connectParmVo.getKingdeeConnectParm().getDbId();
        String uid = connectParmVo.getKingdeeConnectParm().getUid();
        String pwd = connectParmVo.getKingdeeConnectParm().getPwd();
        int lang = connectParmVo.getKingdeeConnectParm().getLang();
        String loginResult = new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            throw new KingdeeConnectException(KingDeeConstant.URL);
        }
        com.alibaba.fastjson.JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e) {
            throw new KingdeeConnectException(KingDeeConstant.PORT);
        }
        if (!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                throw new KingdeeConnectException(KingDeeConstant.LoginValue);
            } else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                throw new KingdeeConnectException(KingDeeConstant.DBID);
            }
            return Result.OK("参数正确,金蝶云连接成功");
        }
        return Result.OK("参数正确,金蝶云连接成功");
    }

    @Autowired
    IQuartzJobService iQuartzJobService;
    @Autowired
    BaseCommonService baseCommonService;

    /*页面获取保存参数功能*/
    @GetMapping("/GetSaveParm")
    @AutoLog(value = "第三方通用接口-页面获取保存参数功能")
    @ApiOperation(value = "第三方通用接口-页面获取保存参数功能", notes = "第三方通用接口-页面获取保存参数功能")
    public Result GetSaveParm() {
        ConnectParmVo connectParmVo = new ConnectParmVo();
        ImsInitConnectParm imsInitConnectParm = iImsInitConnectParmService.getBaseMapper().selectById("1");
        String k3CloudUrl = imsInitConnectParm.getK3CloudUrl();
        kingdeeConnectParm kingdeeConnectParm = new kingdeeConnectParm();
        kingdeeConnectParm.setK3CloudURL(k3CloudUrl);
        kingdeeConnectParm.setDbId(imsInitConnectParm.getDbid());
        kingdeeConnectParm.setUid(imsInitConnectParm.getUid());
        kingdeeConnectParm.setPwd(imsInitConnectParm.getPwd());
        kingdeeConnectParm.setLang(imsInitConnectParm.getLang());
        imsConnectParm imsConParm = new imsConnectParm();
        imsConParm.setUrl(imsInitConnectParm.getUrl());
        connectParmVo.setKingdeeConnectParm(kingdeeConnectParm);
        connectParmVo.setImsConParm(imsConParm);
        QuartzJob quartzJob = iQuartzJobService.getBaseMapper().selectById("999");
        connectParmVo.setIsSynchronize(quartzJob.getStatus().equals(-1) ? false : true);
        return Result.OK(connectParmVo);
    }

    private static String c;
    private static final Logger a = LoggerFactory.getLogger(d.class);
    @Autowired
    private IOnlCgformHeadService onlCgformHeadService;

    @PostMapping({"/test/{tbnames}"})
    @ApiOperation(value = "导入数据库表", notes = "导入数据库表-导入数据库表")
    public Result<?> d(@PathVariable("tbnames") String var1, HttpServletRequest var2) {
        String[] var4 = var1.split(",");
        for (int var5 = 0; var5 < var4.length; ++var5) {
            if (oConvertUtils.isNotEmpty(var4[var5])) {
                a.info("[IP] [online数据库导入表]   --表名：" + var4[var5]);
                this.onlCgformHeadService.saveDbTable2Online(var4[var5]);
            }
        }
        return Result.ok("同步完成!");
    }


    @PostMapping("/test2")
    @AutoLog(value = "第三方通用接口-test2")
    @ApiOperation(value = "第三方通用接口-test2", notes = "第三方通用接口-test2")
    public void test2(@RequestParam("uploadFile") MultipartFile zipFile) {
        String targetFilePath = "/oztsystem/storage/";
        String targetFilePath2 = "/data/storage/";
        File targetFile = new File(targetFilePath + zipFile.getOriginalFilename());
        File targetFile2 = new File(targetFilePath2 + "dataTest.txt");
        System.out.println(zipFile.getOriginalFilename());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(targetFile);
            IOUtils.copy(zipFile.getInputStream(), fileOutputStream);
            log.info("------>>>>>>uploaded a file successfully!<<<<<<------");
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                fileOutputStream.close();
            } catch (IOException e) {
                log.error("", e);
            }
        }
        try {
            fileOutputStream = new FileOutputStream(targetFile2);
            IOUtils.copy(zipFile.getInputStream(), fileOutputStream);
            log.info("------>>>>>>uploaded a file successfully!<<<<<<------");
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                fileOutputStream.close();
            } catch (IOException e) {
                log.error("", e);
            }
        }

    }

    //金蝶云登录公用方法
    public void Kingdeelogin() {
        KingdeeK3CloudApiClient client = categoryDao.getClient();
        Boolean result = categoryDao.getResult();
        String dbId = categoryDao.getDbId();
        String uid = categoryDao.getUid();
        String pwd = categoryDao.getPwd();
        int lang = categoryDao.getLang();
        String loginResult = new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.URL);
            throw new KingdeeConnectException(KingDeeConstant.URL);
        }

        com.alibaba.fastjson.JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e) {
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.PORT);
            throw new KingdeeConnectException(KingDeeConstant.PORT);
        }
        if (!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.LoginValue);
                throw new KingdeeConnectException(KingDeeConstant.LoginValue);
            } else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.DBID);
                //throw new KingdeeConnectException(KingDeeConstant.DBID);
            } else {
                result = true;
            }

        }
        try {
            result = client.login(dbId, uid, pwd, lang);
        } catch (Exception e) {
            e.printStackTrace();
        }
        categoryDao.setClient(client);
        log.info("<==========登录公用方法result: " + result);
        categoryDao.setResult(result);
    }

    //金蝶云保存后检验登录参数
    public void AfterKingdeelogin() {
        KingdeeK3CloudApiClient client = categoryDao.getClient();
        Boolean result = categoryDao.getResult();
        String dbId = categoryDao.getDbId();
        String uid = categoryDao.getUid();
        String pwd = categoryDao.getPwd();
        int lang = categoryDao.getLang();
        String loginResult = new String();
        Object[] loginInfo = new Object[]{dbId, uid, pwd, lang};
        try {
            loginResult = client.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", loginInfo, String.class);
        } catch (Exception e) {
            log.error(KingDeeConstant.URL);
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.URL);
        }

        com.alibaba.fastjson.JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSON.parseObject(loginResult);
        } catch (Exception e) {
            log.error(KingDeeConstant.PORT);
            result = false;
            categoryDao.setLoginResult(KingDeeConstant.PORT);
        }
        if (!ObjectUtils.isEmpty(jsonObject)) {
            if (KingDeeConstant.LoginValue.equals(jsonObject.get("Message"))) {
                log.error(KingDeeConstant.LoginValue);
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.LoginValue);
            } else if (KingDeeConstant.DBID.equals(jsonObject.get("Message"))) {
                log.error(KingDeeConstant.DBID);
                result = false;
                categoryDao.setLoginResult(KingDeeConstant.DBID);
            } else {
                result = true;
            }

        }
        try {
            result = client.login(dbId, uid, pwd, lang);
        } catch (Exception e) {
            e.printStackTrace();
        }
        log.info("<==========检验登录参数result: " + result);
        categoryDao.setClient(client);
        categoryDao.setResult(result);
    }
}
