package org.jeecg.modules.iost.ims.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Data
@TableName("ims_common_push")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ims_common_push对象", description = "通用下推类")
public class ImsCommonPush {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;


    /**
     * ims标识
     */
    @Excel(name = "ims标识", width = 15)
    @ApiModelProperty(value = "ims标识")
    private String docType;


    /**
     * 子标识
     */
    @Excel(name = "子标识", width = 15)
    @ApiModelProperty(value = "子标识")
    private String sFormId;


    /**
     * 子行内吗
     */
    @Excel(name = "子行内吗", width = 15)
    @ApiModelProperty(value = "子行内吗")
    private String entryIdName;


    /**
     * 父标识
     */
    @Excel(name = "父标识", width = 15)
    @ApiModelProperty(value = "父标识")
    private String fathersFormId;


    /**
     * 父行内吗
     */
    @Excel(name = "父行内吗", width = 15)
    @ApiModelProperty(value = "父行内吗")
    private String fatherEntryIdName;


    /**
     * 下推规则
     */
    @Excel(name = "下推规则", width = 15)
    @ApiModelProperty(value = "下推规则")
    private String pushRule;


    /**
     * 子源单行内码
     */
    @Excel(name = "子源单行内码", width = 15)
    @ApiModelProperty(value = "子源单行内码")
    private String linkFsIdName;


    /**
     * 日志名称
     */
    @Excel(name = "日志名称", width = 15)
    @ApiModelProperty(value = "日志名称")
    private String name;


    /**
     * 欧智通日志名称
     */
    @Excel(name = "欧智通日志名称", width = 15)
    @ApiModelProperty(value = "欧智通日志名称")
    private String oztName;


    /**
     * 下推日志名称
     */
    @Excel(name = "下推日志名称", width = 15)
    @ApiModelProperty(value = "下推日志名称")
    private String pushName;


    /**
     * 字段映射明细
     */
    @Excel(name = "字段映射明细", width = 15)
    @ApiModelProperty(value = "字段映射明细")
    private String detail;


    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;


    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;


    /**
     * 明细暂传值
     */
    @TableField(exist = false)
    @ApiModelProperty(value = "明细暂传值")
    private List<Map<String, String>> tempList;


}
