package org.jeecg.modules.iost.ims.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @Description: 销售出库单
 * @Author: jeecg-boot
 * @Date:   2023-4-23
 * @Version: V1.0
 */


@Data
@TableName("ims_wms_audit")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="ims_wms_audit对象", description="销售出库单")
public class ImsSalOutStock {
    private static final long serialVersionUID = 1L;

    /**主键*/
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
    /**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
    /**创建日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;
    /**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
    /**更新日期*/
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;
    /**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**组织代码*/
    @Excel(name = "组织代码", width = 15)
    @ApiModelProperty(value = "组织代码")
    private String orgId;
    /**通知单编码*/
    @Excel(name = "通知单编码", width = 15)
    @ApiModelProperty(value = "通知单编码")
    private String auditCode;
    /**通知单行号*/
    @Excel(name = "通知单行号", width = 15)
    @ApiModelProperty(value = "通知单行号")
    private String auditSeq;
    /**客户编码*/
    @Excel(name = "客户编码", width = 15)
    @ApiModelProperty(value = "客户编码")
    private String custCode;
    /**出货日期*/
    @Excel(name = "出货日期", width = 15)
    @ApiModelProperty(value = "出货日期")
    private String shipDate;
    /**货主类型*/
    @Excel(name = "货主类型", width = 15)
    @ApiModelProperty(value = "货主类型")
    private String shipType;
    /**货主编码*/
    @Excel(name = "货主编码", width = 15)
    @ApiModelProperty(value = "货主编码")
    private String shipCode;
    /**仓库编码*/
    @Excel(name = "仓库编码", width = 15)
    @ApiModelProperty(value = "仓库编码")
    private String storeCode;
    /**物料编码*/
    @Excel(name = "物料编码", width = 15)
    @ApiModelProperty(value = "物料编码")
    private String mtrlCode;
    /**数量*/
    @Excel(name = "数量", width = 15)
    @ApiModelProperty(value = "数量")
    private String mqty;
    /**销售订单编码*/
    @Excel(name = "销售订单编码", width = 15)
    @ApiModelProperty(value = "销售订单编码")
    private String saleCode;
    /**销售订单行号*/
    @Excel(name = "销售订单行号", width = 15)
    @ApiModelProperty(value = "销售订单行号")
    private String saleSeq;
    /**备注*/
    @Excel(name = "备注", width = 15)
    @ApiModelProperty(value = "备注")
    private String remark;
    /**主键ID*/
    @Excel(name = "主键ID", width = 15)
    @ApiModelProperty(value = "主键ID")
    private String fid;
}
