package org.jeecg.modules.iost.ims.kingdeeadapter.model;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

/**
 * @author Inori
 */
public class DelayedElement implements Delayed {

    private long mills;

    public DelayedElement(Integer min) {
        this.mills = System.currentTimeMillis() / 1000 + (60 * min);
    }

    /**
     * 当方法返回小于或等于0的数值时， 元素将会被消耗
     */
    @Override
    public long getDelay(TimeUnit unit) {
        return mills - (System.currentTimeMillis() / 1000);
    }

    /**
     * DelayQueue底层是优先队列，需要实现compareTo方法，
     * 用于在入列的时候与容器中的数据进行比较，以便确定元素位置。
     */
    @Override
    public int compareTo(Delayed o) {
        return (int) (mills - ((DelayedElement) o).getMills());
    }

    public long getMills() {
        return mills;
    }

    public void setMills(long mills) {
        this.mills = mills;
    }

    public static void main(String[] args) {
        System.out.println("{\"parameters\":[{\"http\":{\"encode\":\"YHHD000775\",\"formId\":\"LQKJ_Bankslip\",\"name\":\"SZ000352CMB02U755915671510703715B000048730_1.pdf\",\"url\":\"http://s3gw.cmburl.cn:8081/s/L2xmNDJfMDFfY2JzZmlsZXMuMTAvU1owMDAzNTJDTUIwMlU3NTU5MTU2NzE1MTA3MDM3MTVCMDAwMDQ4NzMwXzEucGRmP0FXU0FjY2Vzc0tleUlkPWxmNDJfdXNlcjcmRXhwaXJlcz0xNzAyMzY1OTIxJlNpZ25hdHVyZT1ZVGFqczEzNGgydkRQUWRSWVZ3OTk0cDV6RkUlM0QmcmVzcG9uc2UtY29udGVudC1kaXNwb3NpdGlvbj1hdHRhY2htZW50JTNCZmlsZW5hbWUlM0RTWjAwMDM1MkNNQjAyVTc1NTkxNTY3MTUxMDcwMzcxNUIwMDAwNDg3MzBfMS5wZGY=/VmkS-iQueXzTFC6KmSKTQuo1OCw=/lf42-user7-dmz/0\"}}]}");
    }
}
