package org.jeecg.modules.iost.ims.kingdeeapi;

import lombok.extern.slf4j.Slf4j;
import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.alibaba.druid.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Component
@Slf4j
public class BillOfMaterialKingDeeApi {

    @Autowired
    private CategoryDao categoryDao;

    private static final String FORM_ID = "PRD_PPBOM";

    private static final String KING_DEE_LOG_NAME = "生产用料清单";

    public String addTwo(List<Map<String, Object>> lists) {
        Map<String, Object> data = new LinkedHashMap<>(6);
        data.put("FormId", FORM_ID);
        data.put("IsInTransaction", true);
        data.put("isAutoSubmit", "save");
        data.put("IsVerifyBaseDataField",true);
        data.put("Model", imsToKingDee(lists));
        //测试生产用料清单
        log.info("wss_addTwo---data:"+data);
        return categoryDao.addReturnResult02(KING_DEE_LOG_NAME, data);
    }

    /**
     * 查询FID
     */
    public List<List<Object>> getFid(String temp01, String temp02) {
        List<List<Object>> lists = categoryDao.select("PRD_PPBOM", new LinkedHashMap<String, String>() {{
            put("FID", "FID");
        }}, new HashMap<String, String>() {{
            put("FMOBillNO", temp01);
            put("FMOEntrySeq", temp02);
        }});
        if (CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if (lists.isEmpty() || ("").equals(lists.get(0).get(0).toString())) {
            return null;
        } else if (lists.get(0).get(0).toString().contains("Errors")) {
            return null;
        }
        return lists;
    }

    /**
     * 查询行标识
     */
    public List<List<Object>> getRowId(String fid, String mainCode) {
        List<List<Object>> lists = categoryDao.select("PRD_PPBOM", new LinkedHashMap<String, String>() {{
            //行主键查询产品编码
            put("FROWID", "FROWID");
        }}, new HashMap<String, String>() {{
            put("FID", fid);
            put("FMaterialID2.Fnumber", mainCode);
        }});
        System.out.println(lists);
        if (CollectionUtils.isEmpty(lists)) {
            return null;
        }
        if (lists.isEmpty() || ("").equals(lists.get(0).get(0).toString())) {
            return null;
        } else if (lists.get(0).get(0).toString().contains("Errors")) {
            return null;
        }
        return lists;
    }

    public Map<String, Object> imsToKingDee(List<Map<String, Object>> list) {
        /* 单据头 */
        Map<String, Object> modelMap = new LinkedHashMap<>();

        //生产订单
        String[] wplanCode = String.valueOf(list.get(0).get("wplan_code")).split("_");
        Integer integer = Integer.valueOf(wplanCode[1]);
        List<List<Object>> objectList = getFid(wplanCode[0], String.valueOf(integer));
        if (objectList != null) {
            modelMap.put("FID", objectList.get(0).get(0));
        } else {
            modelMap.put("FID", null);
        }
        List<Map<String, Object>> entryList = new ArrayList<>();
        for (Map<String, Object> map : list) {
            //转换成金蝶云格式
            Map<String, Object> fEntityMap = new LinkedHashMap<>(10);
            String entryId = "";
            if(map.get("erp_sic") != null)
            {
            	entryId = map.get("erp_sic").toString();
            }
            //行内码
            fEntityMap.put("FEntryID", entryId);
            if(!StringUtils.isEmpty(entryId))
            {
            //物料编码
	            fEntityMap.put("FMaterialID2", new HashMap<String, Object>(1) {{
	                put("FNumber", map.get("mtrl_code"));
	            }});
            }
            //用量（应发数量）
            //fEntityMap.put("FMustQty", map.get("dosage"));
            //净需求数量
            fEntityMap.put("FStdQty", map.get("nn_qty"));
            //实际需求数量
            fEntityMap.put("FNeedQty2", map.get("tn_qty"));
            //是否主料（父级行主键）
            if ("N".equals(String.valueOf(map.get("is_main")))) {
                List<List<Object>> tempList = getRowId(String.valueOf(modelMap.get("FID")), String.valueOf(map.get("main_code")));
                if (tempList != null) {
                    if (!tempList.get(0).get(0).toString().contains("Errors") && !CollectionUtils.isEmpty(tempList.get(0))) {
                        fEntityMap.put("FParentRowId", tempList.get(0).get(0));
                    }
                }
            }
            //使用比例
            String code = this.getTopLevel(list, String.valueOf(map.get("main_code")));
            List<Map<String, Object>> tempList = this.tree(list, code);
            if (!CollectionUtils.isEmpty(tempList)) {
                tempList.add(list.stream().filter(m -> code.equals(String.valueOf(m.get("mtrl_code")))).findFirst().orElse(new HashMap<>()));
                double tnQty = Double.parseDouble(String.valueOf(map.get("tn_qty")));
                double tnQtyTotal = tempList.stream().mapToDouble(m -> Double.parseDouble(String.valueOf(m.get("tn_qty")))).sum();
                String ratio = Double.toString((tnQty / tnQtyTotal));
                BigDecimal value = new BigDecimal(ratio).setScale(6, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100"));
                fEntityMap.put("FUseRate", value);
            } else {
                fEntityMap.put("FUseRate", 100);
            }

            entryList.add(fEntityMap);
        }

        modelMap.put("FEntity", entryList);
        //测试生产用料清单
        System.out.println("imsToKingDee---modelMap:"+modelMap);

        return modelMap;
    }

    public String getTopLevel(List<Map<String, Object>> dataList, String code) {
        List<Map<String, Object>> tempList = dataList.stream()
                .filter(m -> code.equals(String.valueOf(m.get("mtrl_code"))))
                .collect(Collectors.toList());
        for (Map<String, Object> temp : tempList) {
            if ("Y".equals(String.valueOf(temp.get("is_main")))) {
                return String.valueOf(temp.get("mtrl_code"));
            }
            return this.getTopLevel(dataList, String.valueOf(temp.get("main_code")));
        }
        return "";
    }

    public List<Map<String, Object>> tree(List<Map<String, Object>> dataList, String code) {
        List<Map<String, Object>> response = new ArrayList<>();

        List<Map<String, Object>> tempList = dataList.stream()
                .filter(m -> code.equals(String.valueOf(m.get("main_code"))) && !code.equals(String.valueOf(m.get("mtrl_code"))))
                .collect(Collectors.toList());
        for (Map<String, Object> temp : tempList) {
            response.add(temp);
            response.addAll(this.tree(dataList, String.valueOf(temp.get("mtrl_code"))));
        }
        return response;
    }


}
