package org.jeecg.modules.iost.ims.kingdeeapi;

import org.jeecg.modules.iost.ims.Dao.CategoryDao;
import org.jeecg.modules.iost.ims.Util.ImsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * 查询金蝶云物料基础信息
 */
@Component
public class BsMtrlKingdeeApi {
    /**
     * 操作的单据体名称
     */
    private String sFormId = "BD_MATERIAL";//物料基础信息
    @Autowired
    private CategoryDao categoryDao;
    private Map<String, String> key = new LinkedHashMap<>();

    public BsMtrlKingdeeApi() {
        /*查询字段*/
        key.put("FMATERIALID", "FMATERIALID");//单据头实体主键
        key.put("FCreateOrgId.FNumber", "FCreateOrgId.FNumber");//创建组织
        key.put("FNumber", "FNumber");//编码
        key.put("FName", "FName");//名称
        key.put("FSpecification", "FSpecification");//规格型号
        key.put("F_LQKJ_FMTRISPCL", "F_LQKJ_FMTRISPCL");//物料分组
        key.put("FCategoryID.Fnumber", "FCategoryID.Fnumber");//货存类别
        key.put("FBaseUnitId.Fnumber", "FBaseUnitId.Fnumber");//单位
        key.put("FIncreaseQty", "FIncreaseQty");//最小包装数量
        key.put("F_LQKJ_Workmanship", "F_LQKJ_Workmanship");//工艺段
        key.put("FCreateDate", "FCreateDate");//创建时间
        key.put("FStockId.Fnumber", "FStockId.Fnumber");//仓库编码
    }

    public List<Map<String, String>> select(Map<String, String> map, List<Map<String, String>> fieldList) {
        //添加自定义金蝶字段
        ImsSynConstants.purchaseKingDee(this.key, fieldList);

        List<List<Object>> list = categoryDao.select(sFormId, key, map, "物料基础信息");
        return PojoToIMS(list, fieldList);
    }

    /**
     * 将查询到的数据封装成本地字段
     */
    private List<Map<String, String>> PojoToIMS(List<List<Object>> list, List<Map<String, String>> fieldList) {
        List<Map<String, String>> salesorderlist = new ArrayList<>();
        if (!list.isEmpty()) {
            if (!list.get(0).get(0).toString().contains("Errors")) {
                for (List<Object> list1 : list) {
                    Map<String, String> salesordermap = new HashMap<>();
                    //添加自定义IMS字段
                    ImsSynConstants.purchaseIms(list1, 12, salesordermap, fieldList);

                    salesordermap.put("fid", list1.get(0).toString());
                    salesordermap.put("orgId", list1.get(1).toString());
                    salesordermap.put("mtrlCode", list1.get(2).toString());
                    salesordermap.put("mtrlName", list1.get(3).toString());
                    salesordermap.put("mtrlDesc", list1.get(4).toString());
                    salesordermap.put("mtrlSpcl", list1.get(5).toString());
                    salesordermap.put("mtrlPtype", list1.get(6).toString());
                    salesordermap.put("munit", list1.get(7).toString());
                    salesordermap.put("packQty", list1.get(8).toString());
                    salesordermap.put("phaseCode", list1.get(9).toString());
                    salesordermap.put("storeCode", String.valueOf(list1.get(11)));
                    salesorderlist.add(salesordermap);
                }
            } else {
                //如果有错误信息则返回
                String message = ImsUtil.getMessage(list.get(0).get(0));

                Map<String, String> error = new HashMap<>();
                error.put("false", message);
                salesorderlist.add(error);
            }
        }
        return salesorderlist;
    }


}
